<?php
class Brivium_ThreadLiveUpdate_ControllerPublic_Thread extends XFCP_Brivium_ThreadLiveUpdate_ControllerPublic_Thread {

	
	public function actionIndex(){
		$action = parent::actionIndex();
		
		$nodeId = $action->params['forum']['node_id'];
		
		$canUseThreadLiveUpdate = self::canUseThreadLiveUpdate($nodeId);
		if($canUseThreadLiveUpdate){
			$action->params['brCanUseThreadLiveUpdate']=true;
		}
		
		$canUseThreadLiveUpdateTools = self::canUseThreadLiveUpdateTools();
		if($canUseThreadLiveUpdateTools){
			$action->params['brCanUseThreadLiveUpdateTools']=true;
		}
		
		return $action;
	}
	public function actionThreadUpdate(){
		
		$threadId = $this->_input->filterSingle('br_thread_id', XenForo_Input::UINT);
		$lastDate = $this->_input->filterSingle('last_date', XenForo_Input::UINT);
		
		$visitor = XenForo_Visitor::getInstance();
		
		$ftpHelper = $this->getHelper('ForumThreadPost');
		$threadFetchOptions = array('readUserId' => $visitor['user_id']);
		$forumFetchOptions = array('readUserId' => $visitor['user_id']);
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId, $threadFetchOptions, $forumFetchOptions);
		
		$limit = XenForo_Application::getOptions()->BRTLU_maxThreadOnLoad;
		$viewParams = $this->_getNewPostsOtherId($thread, $forum, $lastDate, $limit);
		
		$post = $viewParams['posts'];
		if(!empty($viewParams)){
			foreach ($post as $key => $value){
				$viewParams['posts'][$key]['isNew']=true;
			}
		}
		
		$displaySignature = XenForo_Application::getOptions()->BRTLU_displaySignature;
		if (!$displaySignature) {
			foreach ($viewParams['posts'] as $key => $value){
				$viewParams['posts'][$key]['signature']='';
			}
		}
		return $this->responseView(
				'XenForo_ViewPublic_Thread_ViewNewPosts',
				'thread_reply_new_posts',
				$viewParams
		);
	}
	
	
	protected function _getNewPostsOtherId(array $thread, array $forum, $lastDate, $limit = 3)
	{
		$postModel = $this->_brGetPostModel();
		$visitor = XenForo_Visitor::getInstance();

		$postFetchOptions = $this->_getPostFetchOptions($thread, $forum);
		
		$postFetchOptions += array(
				'limit' => $limit,
		);
		
		$posts = $postModel->brGetNewestPostsInThreadAfterDate(
			$thread['thread_id'], $lastDate, $postFetchOptions
		);

		$posts = $postModel->getAndMergeAttachmentsIntoPosts($posts);
		
		return $this->_getDefaultViewParams($forum, $thread, $posts, null, array(
			'firstUnshownPost' => false,
			'lastPost' => end($posts)
		));
	}
	
	
	public function actionAllowUpdate(){
		$this->_assertPostOnly();
		
		$settings = $this->_input->filter(array(
				'br_thread_update' => XenForo_Input::UINT
		));
		
		if (!$this->_brSaveThreadUpdate($settings))
		{
			return $this->responseError();
		}
	
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		
		$currentPage = $this->_input->filterSingle('page', XenForo_Input::UINT);
		
	
		return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
				XenForo_Link::buildPublicLink('threads', $thread,array('page'=>$currentPage))
		);
	}
	
	public function canUseThreadLiveUpdate($nodeId = ''){
		$permission = XenForo_Visitor::getInstance()->hasPermission('forum', 'BRTLU_threadLiveUpdate');
		if(!$permission){
			return false;
		}
		
		$optionsExcludeForum = XenForo_Application::getOptions()->BRTLU_excludeForum;
		foreach ($optionsExcludeForum as $value){
			if($value == $nodeId){
				return false;
			}
		}
		
		return true;
	}
	
	public function canUseThreadLiveUpdateTools(){
		$permission = XenForo_Visitor::getInstance()->hasPermission('forum', 'BRTLU_threadUpdateTools');
		if(!$permission){
			return false;
		}
		return true;
	}
	
	
	protected function _brSaveThreadUpdate($settings)
	{
		$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
		$writer->setExistingData(XenForo_Visitor::getUserId());
		$writer->bulkSet($settings);
		$writer->save();
	
		return $writer;
	}
	
	protected function _brGetPostModel()
	{
		return $this->getModelFromCache('Brivium_ThreadLiveUpdate_Model_Post');
	}
	
}