<?php

/**
 * Handles alerts of conversations.
 *
 * @package ConvEss
 */
class ConvEss_AlertHandler_ConvEss extends XenForo_AlertHandler_Abstract
{
	/**
	 * Fetches the content required by alerts.
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_Alert $model Alert model invoking this
	 * @param integer $userId User ID the alerts are for
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, $userId, array $viewingUser)
	{
		// no real ids to deal with as alert has no content associated, so just return a simple array
		$contentArray = array();
		foreach ($contentIds AS $id)
		{
			$contentArray[] = $id;
		}
		return $contentArray;
	}
	
	protected function _prepareFull(array $item)
	{
		// these alerts have no content
		return $item;
	}
	
	protected function _prepareKick(array $item)
	{
		if ($item['extra_data'])
		{
			$item['extra'] = unserialize($item['extra_data']);
		}
		unset($item['extra_data']);
		
		if (isset($item['extra']['conversation_title']))
			$item['title'] = XenForo_Helper_String::censorString($item['extra']['conversation_title']);
		
		if (isset($item['extra']['user_reason']))
			$item['reason'] = XenForo_Helper_String::censorString($item['extra']['user_reason']);
		
		return $item;
	}
}