<?php

/**
 * Handles alerts of conversations.
 *
 * @package ConvEss
 */
class ConvEss_AlertHandler_Like extends XenForo_AlertHandler_Abstract
{	
	/**
	 * Fetches the content required by alerts.
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_Alert $model Alert model invoking this
	 * @param integer $userId User ID the alerts are for
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, $userId, array $viewingUser)
	{
		$conversationModel = $model->getModelFromCache('XenForo_Model_Conversation');
		$messages = $conversationModel->getMessagesForLikesByIds($contentIds);
		return $messages;
	}
	
	protected function _prepareLike(array $item)
	{
		if (!isset($item['user']['username']))
		{
			$item['user']['username'] = new XenForo_Phrase('deleted_user_parentheses');
			$item['user']['user_id'] = 0;
		}
		$item['title'] = XenForo_Helper_String::censorString($item['content']['title']);
		$item['link'] = XenForo_Link::buildPublicLink('conversations/message', '', array('message_id' =>  $item['content_id']));
		
		return $item;
	}
}