<?php

class ConvEss_Callback_Options
{
	public static function verifyOption($value, XenForo_DataWriter $dw, $fieldName)
	{
		if ($fieldName == 'convess_mod_away_num_days')
		{
			$numdays = XenForo_Application::get('options')->convess_mod_away_cron_last_message_num_days;
			
			if ($numdays && $value >= $numdays)
			{
				$dw->error(new XenForo_Phrase('convess_mod_away_num_days_option_error'), $fieldName);
				return false;
			}
		}
		else if ($fieldName == 'convess_mod_away_cron_last_message_num_days')
		{
			$numdays = XenForo_Application::get('options')->convess_mod_away_num_days;
			
			if ($numdays && $value <= $numdays)
			{
				$dw->error(new XenForo_Phrase('convess_mod_away_cron_days_option_error'), $fieldName);
				return false;
			}
		}
		
		return true;
	}
}