<?php

/**
 * Inline moderation actions for conversations
 *
 * @package ConvEss
 */
class ConvEss_ControllerPublic_InlineMod_Conversation extends XFCP_ConvEss_ControllerPublic_InlineMod_Conversation
{
	/**
	 * Stick a conversation
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionStick()
	{
		return $this->_callAction('stick');
	}
	
	/**
	 * Unstick a conversation
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionUnstick()
	{
		return $this->_callAction('unstick');
	}
	
	/**
	 * Lock a conversation
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionLock()
	{
		return $this->_callAction('lock');
	}
	
	/**
	 * Unlock a conversation
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionUnLock()
	{
		return $this->_callAction('unlock');
	}
	
	/**
	 * Set conversation prefix.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionPrefix()
	{
		if ($this->isConfirmedPost())
		{
			$conversationIds = $this->getInlineModIds(false);
			$prefixId = $this->_input->filterSingle('prefix_id_inline', XenForo_Input::UINT);
	
			$handler = $this->getInlineModTypeModel();
			$handler->setPrefix($conversationIds, $prefixId);
			
			$this->clearCookie();
			
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				$this->getDynamicRedirect()
			);
		}
		else // show prefix selection template
		{
			$conversationIds = $this->getInlineModIds();
			$redirect = $this->getDynamicRedirect();
			$conversationModel = $this->_getConversationModel();
			
			$viewingUser = XenForo_Visitor::getInstance()->toArray();
			
			if (!$conversationIds || !$conversationModel->canCreatePrefixes($viewingUser))
			{
				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					$redirect
				);
			}
			
			// prefixes
			$prefixes = $conversationModel->getPrefixes($viewingUser['user_id']);
			$prefixGroups = array();
			
			foreach ($prefixes AS $prefix)
			{
				$prefixes[$prefix['prefix_id']] = $prefix;
			}
			
			$viewParams = array(
				'conversationIds' => $conversationIds,
				'conversationCount' => count($conversationIds),
				'prefixes' => $prefixes,
				'redirect' => $redirect
			);
			
			return $this->responseView('XenForo_ViewPublic_Base', 'convess_inline_mod_conversation_prefix', $viewParams);
		}
	}
	
	/**
	 * Call the specific action
	 *
	 * string $action
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	protected function _callAction($action)
	{
		$this->_assertPostOnly();
		$ids = $this->getInlineModIds(true);
		$dynamicRedirect = true;
		
		switch ($action)
		{	
			case 'stick':
			{
				$this->getInlineModTypeModel()->setStickState($ids, 1);
				$dynamicRedirect = false; // load first page to show the stickies
				break;
			}
			case 'unstick':
			{
				$this->getInlineModTypeModel()->setStickState($ids, 0);
				break;	
			}
			case 'lock':
			{
				$this->getInlineModTypeModel()->setLockState($ids, 0);
				break;
			}
			case 'unlock':
			{
				$this->getInlineModTypeModel()->setLockState($ids, 1);
				break;
			}
		}
		
		$this->clearCookie();
		
		if ($dynamicRedirect)
		{
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				$this->getDynamicRedirect()
			);		
		}
		else
		{
			// load first page
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildPublicLink('conversations')
			);		
		}	
	}
	
	/**
	 * @return XenForo_Model_InlineMod_Thread
	 */
	public function getInlineModTypeModel()
	{
		return $this->getModelFromCache('XenForo_Model_InlineMod_Conversation');
	}
	
	/**
	 * @return XenForo_Model_Conversation
	 */
	protected function _getConversationModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}
}