<?php

/**
 * Ensures conversations directed at moderators do not go un-answered
 *
 * @package ConvEss
 */
class ConvEss_CronEntry_ModAway
{
	/**
	 * Auto Responds to conversations if no reply for X number of days
	 */
	public static function modAway()
	{
		$options = XenForo_Application::get('options');
		$numDays = $options->convess_mod_away_num_days;
		
		if ($numDays > 0 && $options->convess_mod_away_cron)
		{
			$conversationModel = XenForo_Model::create('XenForo_Model_Conversation');
			$userModel = XenForo_Model::create('XenForo_Model_User');
			$timeNow = XenForo_Application::$time;
			$cutOff = $timeNow - ($numDays * 86400); // mod away cutoff days
			$conversationNumDays = $options->convess_mod_away_cron_last_message_num_days; 
			$lastMessageCutOff = $timeNow - ($conversationNumDays * 86400); // conversation cutoff days
						
			// list of moderators and admins
			$mods = $userModel->getAdminsAndMods();
			foreach ($mods AS $modId => $mod)
			{
				// those who have not logged-in for X number of days
				if ($mod['effective_last_activity'] < $cutOff)
				{
					// find conversations where recipient is the mod and reply count is 0 (ie un-answered)
					$conversations = $conversationModel->findConversationsWithNoRepliesByRecipientId($modId, $lastMessageCutOff);
					
					foreach ($conversations AS $conversation)
					{
						$conversationId = $conversation['conversation_id'];
						$autoResponseActive = false;
						$autoResponse = $conversationModel->getAutoResponse($modId, 1);
						if (!empty($autoResponse))
						{
							$dates = unserialize($autoResponse['dates']);
							
							// start date/time
							$startDate = $dates['start']['ymd'];
							$startHour = $dates['start']['hh'];
							$startMinute = $dates['start']['mm'];
							$datetimeStart = new DateTime("$startDate $startHour:$startMinute", new DateTimeZone($mod['timezone']));
							
							// end date/time
							$endDate = $dates['end']['ymd'];
							$endHour = $dates['end']['hh'];
							$endMinute = $dates['end']['mm'];
							$datetimeEnd = new DateTime("$endDate $endHour:$endMinute", new DateTimeZone($mod['timezone']));
							
							if ($timeNow >= $datetimeStart->format('U'))
							{
								if ($timeNow < $datetimeEnd->format('U')) // active
								{
									$conversationModel->sendAutoResponse($conversationId, $mod, $autoResponse['message']);
									$autoResponseActive = true;
								}
								else // expired
								{
									// set state as inactive
									$conversationModel->autoResponseSetActiveState($mod['user_id'], 0, $errorKey);
								}
							}
						}
						
						// send out a general auto response as the moderator's auto response was not active
						if (!$autoResponseActive)
						{
							$message = $conversationModel->getGeneralAutoResponseMessage($conversationId, $conversation['username'], $mod['username']);
							$conversationModel->sendAutoResponse($conversationId, $mod, $message);
						}
					}
				}
			}
		}
	}
}