<?php

/**
* Data writer for convess_auto_response.
*
* @package ConvEss
*/
class ConvEss_DataWriter_AutoResponse extends XenForo_DataWriter
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
				'convess_auto_response'	=> array(
				'user_id'               => array('type' => self::TYPE_UINT, 'required' => true),
				'active'                => array('type' => self::TYPE_BOOLEAN, 'default' => 1),
				'dates'        			=> array('type' => self::TYPE_UNKNOWN),
				'message'               => array('type' => self::TYPE_STRING),
				'exclude'               => array('type' => self::TYPE_BOOLEAN, 'default' => 0)
			)
		);
	}
	
	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$userId = $this->_getExistingPrimaryKey($data, 'user_id'))
		{
			return false;
		}

		return array('convess_auto_response' => $this->_getConversationdModel()->getAutoResponse($userId));
	}
	
	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'user_id = ' . $this->_db->quote($this->getExisting('user_id'));
	}
	
	/**
	 * @return XenForo_Model_Conversation
	 */
	protected function _getConversationdModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}
}