<?php

/**
* Data writer for convess.
*
* @package ConvEss
*/
class ConvEss_DataWriter_ConvEss extends XenForo_DataWriter
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
				'convess'	=> array(
				'conversation_id'   		=> array('type' => self::TYPE_UINT, 'required' => true),
				'user_id'    				=> array('type' => self::TYPE_UINT, 'required' => true),
				'prefix_id'  				=> array('type' => self::TYPE_UINT, 'default' => 0),
				'sticky'    				=> array('type' => self::TYPE_BOOLEAN, 'default' => 0),
				'last_read_message_id'		=> array('type' => self::TYPE_UINT, 'default' => 0),
				'last_read_message_date'	=> array('type' => self::TYPE_UINT, 'default' => 0),
				'auto_responded'    		=> array('type' => self::TYPE_BOOLEAN, 'default' => 0),
				'kicked'    				=> array('type' => self::TYPE_BOOLEAN, 'default' => 0)
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!is_array($data))
		{
			return false;
		}
		else if (isset($data['conversation_id'], $data['user_id']))
		{
			$conversationId = $data['conversation_id'];
			$userId = $data['user_id'];
			return array('convess' => $this->_getConversationdModel()->getConvessByConversationUserId($conversationId, $userId));
		}

		return false;
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		$conversationId = $this->_db->quote($this->getExisting('conversation_id'));
		$userId = $this->_db->quote($this->getExisting('user_id'));
		return 'conversation_id = ' . $conversationId . ' AND user_id = ' . $userId;
	}

	/**
	 * @return XenForo_Model_Conversation
	 */
	protected function _getConversationdModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}
}