<?php

/**
* Data writer for conversation masters.
*
* @package ConvEss
*/
class ConvEss_DataWriter_ConversationMaster extends XFCP_ConvEss_DataWriter_ConversationMaster
{
	/**
	 * Post-save handling.
	 */
	protected function _postSave()
	{
		parent::_postSave();
		
		if ($this->isInsert() && $this->get('conversation_open'))
		{
			$conversation = $this->getMergedData();
			$userModel = $this->getModelFromCache('XenForo_Model_User');
			$recipients = $userModel->getUsersByIds($this->_newRecipients, array('join' => XenForo_Model_User::FETCH_USER_FULL | XenForo_Model_User::FETCH_USER_PERMISSIONS | XenForo_Model_User::FETCH_LAST_ACTIVITY));
			
			if (!empty($recipients))
			{
				$conversationModel = $this->_getConversationModel();
				$actionUser = $this->getExtraData(self::DATA_ACTION_USER);
				$options = XenForo_Application::get('options');
				
				foreach ($recipients AS $recipient)
				{
					if ($recipient['user_id'] != $actionUser['user_id'])
					{
						$conversationId = $conversation['conversation_id'];
						$autoResponseActive = false;
						$autoResponse = $conversationModel->getAutoResponse($recipient['user_id'], 1); // 1 for active state
						if (!empty($autoResponse))
						{
							$recipient['permissions'] = XenForo_Permission::unserializePermissions($recipient['global_permission_cache']);
							if (!$conversationModel->canAutoRespond($recipient))
							{
								// has an auto response but no longer has permission
								$conversationModel->autoResponseDelete($recipient['user_id'], true); // true for existance of auto response established
								continue;
							}
							
							$dates = unserialize($autoResponse['dates']);
							
							// start date/time
							$startDate = $dates['start']['ymd'];
							$startHour = $dates['start']['hh'];
							$startMinute = $dates['start']['mm'];
							$datetimeStart = new DateTime("$startDate $startHour:$startMinute", new DateTimeZone($recipient['timezone']));
							
							// end date/time
							$endDate = $dates['end']['ymd'];
							$endHour = $dates['end']['hh'];
							$endMinute = $dates['end']['mm'];
							$datetimeEnd = new DateTime("$endDate $endHour:$endMinute", new DateTimeZone($recipient['timezone']));
							
							$timeNow = XenForo_Application::$time;
							if ($timeNow >= $datetimeStart->format('U'))
							{
								if ($timeNow < $datetimeEnd->format('U')) // active
								{
									if (!$userModel->isUserIgnored($recipient, $actionUser['user_id'])) // recipient not ignoring sender
									{
										if (!$options->convess_auto_response_exclude || !$autoResponse['exclude'] || !$userModel->isFollowing($actionUser['user_id'], $recipient)) // exclude responding to those user follows
										{
											// current auto response has not yet left a message in this conversation
											$autoResponded = $conversationModel->hasAutoResponded($conversationId, $recipient['user_id']);
											if (!$autoResponded)
											{
												$conversationModel->sendAutoResponse($conversationId, $recipient, $autoResponse['message']);
											}
										}
									}
									
									$autoResponseActive = true;
								}
								else // expired
								{
									// set state as inactive
									$conversationModel->autoResponseSetActiveState($recipient['user_id'], 0, $errorKey);
								}
							}
						}
						
						// send out a general auto response if is a moderator, and moderator's auto response was not active
						if (!$autoResponseActive && ($recipient['is_admin'] || $recipient['is_moderator']))
						{
							$numDays = $options->convess_mod_away_num_days;
							if ($numDays > 0) // feature is enabled
							{
								// if has not logged-in in X amount of days
								$cutOff = XenForo_Application::$time - ($numDays * 86400);
								if ($recipient['effective_last_activity'] < $cutOff)
								{
									$message = $conversationModel->getGeneralAutoResponseMessage($conversationId, $actionUser['username'], $recipient['username']);
									$conversationModel->sendAutoResponse($conversationId, $recipient, $message);
								}
							}							
						}
					}
				}
			}
		}
	}
	
	/**
	 * Post-delete handling.
	 */
	protected function _postDelete()
	{
		parent::_postDelete();
		
		$db = $this->_db;
		$conversationIdQuoted = $db->quote($this->get('conversation_id'));

		$db->delete('convess', 'conversation_id = ' . $conversationIdQuoted);
	}
}