<?php

/**
* Data writer for convess.
*
* @package ConvEss
*/
class ConvEss_DataWriter_MessageLikes extends XenForo_DataWriter
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
				'convess_message_likes'	=> array(
				'message_id'   		=> array('type' => self::TYPE_UINT, 'required' => true),
				'likes' 			=> array('type' => self::TYPE_UINT_FORCED, 'default' => 0),
				'like_users'    	=> array('type' => self::TYPE_SERIALIZED, 'default' => 'a:0:{}')
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$messageId = $this->_getExistingPrimaryKey($data, 'message_id'))
		{
			return false;
		}

		return array('convess_message_likes' => $this->_getConversationdModel()->getMessageLikes($messageId));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'message_id = ' . $this->_db->quote($this->getExisting('message_id'));
	}

	/**
	 * @return XenForo_Model_Conversation
	 */
	protected function _getConversationdModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}
}