<?php

/**
* Data writer for convess_group.
*
* @package ConvEss
*/
class ConvEss_DataWriter_ParticipantGroup extends XenForo_DataWriter
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
				'convess_group'	=> array(
				'group_id'  	=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'user_id'    	=> array('type' => self::TYPE_UINT, 'required' => true),
				'group_name'	=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 30)
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$groupId = $this->_getExistingPrimaryKey($data, 'group_id'))
		{
			return false;
		}

		return array('convess_group' => $this->_getConversationdModel()->getParticipantGroupById($groupId));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'group_id = ' . $this->_db->quote($this->getExisting('group_id'));
	}
	
	protected function _postDelete()
	{
		// group users
		$db = $this->_db;
		$db->delete('convess_group_user', 'group_id = ' . $db->quote($this->get('group_id')));		
	}

	/**
	 * @return XenForo_Model_Conversation
	 */
	protected function _getConversationdModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}
}