<?php

/**
* Data writer for convess_group_user.
*
* @package ConvEss
*/
class ConvEss_DataWriter_ParticipantGroupUser extends XenForo_DataWriter
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
				'convess_group_user'	=> array(
				'group_id'  			=> array('type' => self::TYPE_UINT, 'required' => true),
				'user_id'  				=> array('type' => self::TYPE_UINT, 'required' => true),
				'username' 				=> array('type' => self::TYPE_STRING, 'maxLength' => 50, 'required' => true)
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!is_array($data))
		{
			return false;
		}
		else if (isset($data['group_id'], $data['user_id']))
		{
			$groupId = $data['group_id'];
			$userId = $data['user_id'];
			return array('convess_group_user' => $this->_getConversationdModel()->getParticipantGroupUserById($groupId, $userId));
		}

		return false;
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		$groupId = $this->_db->quote($this->getExisting('group_id'));
		$userId = $this->_db->quote($this->getExisting('user_id'));
		return 'group_id = ' .  $groupId . ' AND user_id = ' . $userId;
	}

	/**
	 * @return XenForo_Model_Conversation
	 */
	protected function _getConversationdModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}
}