<?php

/**
* Data writer for convess_prefix.
*
* @package ConvEss
*/
class ConvEss_DataWriter_Prefix extends XenForo_DataWriter
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
				'convess_prefix'	=> array(
				'prefix_id'			=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'user_id'   		=> array('type' => self::TYPE_UINT, 'required' => true),
				'title'				=> array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 30),
				'display_order' 	=> array('type' => self::TYPE_UINT, 'default' => 0),
				'css_class'			=> array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 50)
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$prefixId = $this->_getExistingPrimaryKey($data, 'prefix_id'))
		{
			return false;
		}

		return array('convess_prefix' => $this->_getConversationdModel()->getPrefixById($prefixId));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'prefix_id = ' . $this->_db->quote($this->getExisting('prefix_id'));
	}

	/**
	 * @return XenForo_Model_Conversation
	 */
	protected function _getConversationdModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}
}