<?php

/**
* Data writer for convess_user_options.
*
* @package ConvEss
*/
class ConvEss_DataWriter_UserOptions extends XenForo_DataWriter
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		$listViewDefault = XenForo_Application::get('options')->convess_view;
		if ($listViewDefault == 'avatars')
			$listViewDefault = 1;
		else
			$listViewDefault = 0;
		
		return array(
				'convess_user_options'	=> array(
				'user_id'   			=> array('type' => self::TYPE_UINT, 'required' => true),
				'allow_last_read_date' 	=> array('type' => self::TYPE_BOOLEAN, 'default' => 1),
				'list_view_avatars' 	=> array('type' => self::TYPE_BOOLEAN, 'default' => $listViewDefault)
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$userId = $this->_getExistingPrimaryKey($data, 'user_id'))
		{
			return false;
		}

		return array('convess_user_options' => $this->_getConversationdModel()->getConvEssUserOptionsByUserId($userId));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'user_id = ' . $this->_db->quote($this->getExisting('user_id'));
	}

	/**
	 * @return XenForo_Model_Conversation
	 */
	protected function _getConversationdModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}
}