<?php

class ConvEss_Install_Construct
{
	public static function install($existingAddOn, $addOnData)
	{
		if (XenForo_Application::$versionId < 1020033)
		{
			throw new XenForo_Exception('This Add-On requires XenForo version 1.2.0 Beta 3 or newer.');
		}
		
		$db = XenForo_Application::get('db');
		
		if ($existingAddOn) // upgrade
		{
			$rebuildContentTypeCache = false;
			$versionId = $existingAddOn['version_id'];
			
			if ($versionId < 101)
			{
				$db->query("
					CREATE TABLE IF NOT EXISTS convess_prefix (
						prefix_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
						user_id INT UNSIGNED NOT NULL,
						title VARCHAR(30) NOT NULL,
						display_order INT UNSIGNED NOT NULL DEFAULT 0,
						css_class VARCHAR(50) NOT NULL DEFAULT '',
						PRIMARY KEY (prefix_id),
						KEY user_id (user_id)
					) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
				");		
			}
			
			if ($versionId < 108)
			{
				$tableColumns = $db->describeTable('convess');
				$lastReadMessageIdExists = array_key_exists('last_read_message_id', $tableColumns);
				$lastReadMessageDateExists = array_key_exists('last_read_message_date', $tableColumns);
				
				if (!$lastReadMessageIdExists || !$lastReadMessageDateExists)
				{
					if (!$lastReadMessageIdExists && !$lastReadMessageDateExists)
					{
						$db->query("
							ALTER TABLE convess	ADD (
								last_read_message_id INT UNSIGNED NOT NULL DEFAULT 0,
								last_read_message_date INT UNSIGNED NOT NULL DEFAULT 0
							)
						");
					}
					else if (!$lastReadMessageIdExists)
					{
						$db->query("
							ALTER TABLE convess	ADD (
								last_read_message_id INT UNSIGNED NOT NULL DEFAULT 0
							)
						");
					}
					else
					{
						$db->query("
							ALTER TABLE convess	ADD (
								last_read_message_date INT UNSIGNED NOT NULL DEFAULT 0
							)
						");
					}
				}
				
				// user options
				$db->query("
					CREATE TABLE IF NOT EXISTS convess_privacy (
						user_id INT UNSIGNED NOT NULL PRIMARY KEY,
						allow_last_read_date TINYINT UNSIGNED NOT NULL DEFAULT 1
					) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
				");		
			}
			
			if ($versionId < 111)
			{
				$tableColumns = $db->describeTable('convess');
				
				if (!array_key_exists('auto_responded', $tableColumns))
				{
					$db->query("
						ALTER TABLE convess
						ADD auto_responded TINYINT UNSIGNED NOT NULL DEFAULT 0
					");
				}			
			}
			
			if ($versionId < 112)
			{
				$tableColumns = $db->describeTable('convess');
					
				if (!array_key_exists('kicked', $tableColumns))
				{
					$db->query("
						ALTER TABLE convess
						ADD kicked TINYINT UNSIGNED NOT NULL DEFAULT 0
					");
				}
				
				// alert handler
				$db->query("
					INSERT IGNORE INTO xf_content_type_field (content_type, field_name, field_value)
					VALUES ('convess', 'alert_handler_class', 'ConvEss_AlertHandler_ConvEss')
				");
				
				$rebuildContentTypeCache = true;			
			}
			
			if ($versionId < 115)
			{
				XenForo_Db::beginTransaction($db);
				
				// rename the convess_inbox to conversation_message
				$db->query("
					UPDATE xf_content_type_field
					SET content_type = 'conversation_message', field_value = 'ConvEss_AlertHandler_Like'
					WHERE content_type = 'convess_inbox' AND field_name = 'alert_handler_class' AND field_value = 'ConvEss_AlertHandler_ConvEss'
				");
				
				// like handler
				$db->query("
					INSERT IGNORE INTO xf_content_type_field (content_type, field_name, field_value)
					VALUES ('conversation_message', 'like_handler_class', 'ConvEss_LikeHandler_Message')
				");
				
				$db->query("
					CREATE TABLE IF NOT EXISTS convess_message_likes (
						message_id INT UNSIGNED NOT NULL,
						likes INT UNSIGNED NOT NULL DEFAULT 0,
						like_users BLOB NOT NULL,
						PRIMARY KEY (message_id)
					) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
				");
				
				$result = $db->query("SHOW TABLES LIKE 'convess_privacy'"); // ensure it wasn't already renamed to convess_user_options
				if ($result->rowCount() > 0)
				{
					$tableColumns = $db->describeTable('convess_privacy');
					$listViewAvatars = array_key_exists('list_view_avatars', $tableColumns);
					
					if (!$listViewAvatars)
					{
						$listViewDefault = XenForo_Application::get('options')->convess_view;
						if (!$listViewDefault || $listViewDefault == 'usernames')
							$listViewDefault = 0;
						else
							$listViewDefault = 1;
					
						$db->query("
							ALTER TABLE convess_privacy	ADD (
								list_view_avatars INT UNSIGNED NOT NULL DEFAULT " .  $listViewDefault . "
							)
						");
					}
					
					$db->query("
						ALTER TABLE convess_privacy RENAME TO convess_user_options
					");
				}
				
				XenForo_Db::commit($db);
				$rebuildContentTypeCache = true;			
			}
			
			if ($versionId < 119)
			{
				$db->query("
					INSERT IGNORE INTO xf_content_type (content_type, addon_id)
					VALUES ('convess', 'ConvEss')
				");
				
				$rebuildContentTypeCache = true;	
			}
			
			if ($versionId < 125)
			{
				// rename type conversation_message to convess in preparation for the core deciding to include likes and alerts
				$db->query("
					INSERT IGNORE INTO xf_content_type (content_type, addon_id)
					VALUES ('convess_message', 'ConvEss')
				");
				
				$db->query("
					UPDATE xf_content_type_field
					SET content_type = 'convess_message'
					WHERE content_type = 'conversation_message' AND field_name = 'like_handler_class' AND field_value = 'ConvEss_LikeHandler_Message'
				");
				
				$db->query("
					UPDATE xf_content_type_field
					SET content_type = 'convess_message'
					WHERE content_type = 'conversation_message' AND field_name = 'alert_handler_class' AND field_value = 'ConvEss_AlertHandler_Like'
				");
				
				$db->query("
					UPDATE xf_user_alert
					SET content_type = 'convess_message'
					WHERE content_type = 'conversation_message' AND action = 'like'
				");
				
				$db->query("
					UPDATE xf_liked_content
					SET content_type = 'convess_message'
					WHERE content_type = 'conversation_message'
				");
				
				$db->query("
					UPDATE xf_user_alert_optout
					SET alert = 'convess_message_like'
					WHERE alert = 'conversation_message_like'
				");
				
				$rebuildContentTypeCache = true;
			}
			
			if ($versionId < 128)
			{
				$tableColumns = $db->describeTable('convess_auto_response');
				if (!array_key_exists('exclude', $tableColumns))
				{
					$db->query("
						ALTER TABLE convess_auto_response
						ADD exclude TINYINT UNSIGNED NOT NULL DEFAULT 0
					");
				}
			}
			
			if ($rebuildContentTypeCache)
				XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
		}
		else // fresh install
		{
			$db->query("
				INSERT IGNORE INTO xf_content_type (content_type, addon_id)
				VALUES ('convess', 'ConvEss'), ('convess_message', 'ConvEss')
			");
			
			// alert & like handlers
			$db->query("
				INSERT IGNORE INTO xf_content_type_field (content_type, field_name, field_value)
				VALUES ('convess_message', 'alert_handler_class', 'ConvEss_AlertHandler_Like'), ('convess', 'alert_handler_class', 'ConvEss_AlertHandler_ConvEss'), ('convess_message', 'like_handler_class', 'ConvEss_LikeHandler_Message')
			");
			
			// inbox size set to unlimited
			$usergroups = XenForo_Model::create('XenForo_Model_UserGroup')->getAllUserGroups();
			foreach($usergroups AS $usergroup)
			{
				$db->query("
					INSERT IGNORE INTO xf_permission_entry (user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
					VALUES (" . $usergroup['user_group_id'] . ", 0, 'conversation', 'convessInboxSize', 'use_int', -1)
				");
			}
			
			// participant group
			$db->query("
				CREATE TABLE IF NOT EXISTS convess_group (
					group_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
					user_id INT UNSIGNED NOT NULL,
					group_name VARCHAR(30) NOT NULL,
					KEY user_id (user_id),
					UNIQUE KEY user_id_group_name (user_id, group_name)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// participant group user
			$db->query("
				CREATE TABLE IF NOT EXISTS convess_group_user (
					group_id INT UNSIGNED NOT NULL,
					user_id INT UNSIGNED NOT NULL,
					username VARCHAR(50) NOT NULL,
					UNIQUE KEY group_id_user_id (group_id, user_id)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// sticky & prefix
			$db->query("
				CREATE TABLE IF NOT EXISTS convess (
					conversation_id INT UNSIGNED NOT NULL,
					user_id INT UNSIGNED NOT NULL,
					prefix_id INT UNSIGNED NOT NULL DEFAULT 0,
					sticky TINYINT UNSIGNED NOT NULL DEFAULT 0,
					last_read_message_id INT UNSIGNED NOT NULL DEFAULT 0,
					last_read_message_date INT UNSIGNED NOT NULL DEFAULT 0,
					auto_responded TINYINT UNSIGNED NOT NULL DEFAULT 0,
					kicked TINYINT UNSIGNED NOT NULL DEFAULT 0,
					PRIMARY KEY conversation_id_user_id (conversation_id, user_id)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// auto response
			$db->query("
				CREATE TABLE IF NOT EXISTS convess_auto_response (
					user_id INT UNSIGNED NOT NULL,
					active TINYINT UNSIGNED NOT NULL DEFAULT 1,
					dates TINYBLOB,
					message MEDIUMTEXT NOT NULL,
					exclude TINYINT UNSIGNED NOT NULL DEFAULT 0,
					PRIMARY KEY (user_id),
					KEY user_id_active (user_id, active)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			$db->query("
				CREATE TABLE IF NOT EXISTS convess_prefix (
					prefix_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
					user_id INT UNSIGNED NOT NULL,
					title VARCHAR(30) NOT NULL,
					display_order INT UNSIGNED NOT NULL DEFAULT 0,
					css_class VARCHAR(50) NOT NULL DEFAULT '',
					PRIMARY KEY (prefix_id),
					KEY user_id (user_id)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			// user options
			$db->query("
				CREATE TABLE IF NOT EXISTS convess_user_options (
					user_id INT UNSIGNED NOT NULL PRIMARY KEY,
					allow_last_read_date TINYINT UNSIGNED NOT NULL DEFAULT 1,
					list_view_avatars INT UNSIGNED NOT NULL DEFAULT 0
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			$db->query("
				CREATE TABLE IF NOT EXISTS convess_message_likes (
					message_id INT UNSIGNED NOT NULL,
					likes INT UNSIGNED NOT NULL DEFAULT 0,
					like_users BLOB NOT NULL,
					PRIMARY KEY (message_id)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
			");
			
			XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
		}
	}
	
	public static function uninstall()
	{	
		$db = XenForo_Application::get('db');
		
		$db->query("
			DELETE FROM xf_permission_entry
			WHERE permission_id IN ('convessInboxSize', 'convessParticipantGroups', 'convessAutoResponse', 'convessPrefixes', 'convessKickRecipients', 'convessLikeMessages')
		");
		
		$db->query("
			DELETE FROM xf_permission_entry_content
			WHERE permission_id IN ('convessInboxSize', 'convessParticipantGroups', 'convessAutoResponse', 'convessPrefixes', 'convessKickRecipients', 'convessLikeMessages')
		");
		
		$db->query("
			DROP TABLE IF EXISTS convess_group
		");
		
		$db->query("
			DROP TABLE IF EXISTS convess_group_user
		");
		
		$db->query("
			DROP TABLE IF EXISTS convess
		");
		
		$db->query("
			DROP TABLE IF EXISTS convess_auto_response
		");
		
		$db->query("
			DROP TABLE IF EXISTS convess_prefix
		");
		
		$db->query("
			DROP TABLE IF EXISTS convess_message_likes
		");
		
		$db->query("
			DROP TABLE IF EXISTS convess_user_options
		");
		
		$db->query("
			DELETE FROM xf_liked_content
			WHERE content_type = 'convess_message'
		");
		
		$db->query("
			DELETE FROM xf_user_alert
			WHERE content_type = 'convess'
		");
		
		$db->query("
			DELETE FROM xf_user_alert
			WHERE content_type = 'convess_message'
		");
		
		$db->query("
			DELETE FROM xf_user_alert_optout
			WHERE alert = 'convess_message_like'
		");
		
		$db->query("
			DELETE FROM xf_content_type_field
			WHERE content_type = 'convess'
		");
		
		$db->query("
			DELETE FROM xf_content_type_field
			WHERE content_type = 'convess_message'
		");
		
		$db->query("
			DELETE FROM xf_content_type
			WHERE addon_id = 'ConvEss'
		");
		
		XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
	}
}