<?php

/**
 * Handler for the specific conversation message-related like aspects.
 *
 * @package ConvEss
 */
class ConvEss_LikeHandler_Message extends XenForo_LikeHandler_Abstract
{
	/**
	 * Increments the like counter.
	 * @see XenForo_LikeHandler_Abstract::incrementLikeCounter()
	 */
	public function incrementLikeCounter($contentId, array $latestLikes, $adjustAmount = 1)
	{
		$contentId = intval($contentId);
		if (!$contentId)
			throw new XenForo_Exception('Function incrementLikeCounter() - no contentId');
		
		$dw = XenForo_DataWriter::create('ConvEss_DataWriter_MessageLikes');
		$conversationModel = XenForo_Model::create('XenForo_Model_Conversation');
		$exists = $conversationModel->getMessageLikes($contentId);
		
		if (!empty($exists))
		{
			$dw->setExistingData($contentId);
			$numLikes = $dw->get('likes') + $adjustAmount;
		}
		else
		{
			$dw->set('message_id', $contentId);
			$numLikes = $adjustAmount;
		}
		
		if ($numLikes < 1)
		{
			$dw->preDelete();
		}
		else
		{
			$dw->set('likes', $numLikes);
			$dw->set('like_users', $latestLikes);
			$dw->preSave();
		}
		
		if ($dw->hasErrors())
		{
			$errors = $dw->getErrors();
			$errorKey = reset($errors);
			throw new XenForo_Exception($errorKey);
		}
		
		if ($numLikes < 1)
			$dw->delete();
		else
			$dw->save();
	}
	
	/**
	 * Gets content data (if viewable).
	 * @see XenForo_LikeHandler_Abstract::getContentData()
	 */
	public function getContentData(array $contentIds, array $viewingUser)
	{
		$conversationModel = XenForo_Model::create('XenForo_Model_Conversation');
		$messages = $conversationModel->getMessagesForLikesByIds($contentIds);
		
		foreach ($messages AS $messageId => &$message)
		{
			if ($message['user_id'] != $viewingUser['user_id'])
				continue;
			
			$message['title'] = XenForo_Helper_String::censorString($message['title']);	
			$message['link'] = XenForo_Link::buildPublicLink('conversations/message', '', array('message_id' => $messageId));
		}
		
		return $messages;
	}
	
	/**
	 * @see XenForo_LikeHandler_Abstract::batchUpdateContentUser()
	 */
	public function batchUpdateContentUser($oldUserId, $newUserId, $oldUsername, $newUsername)
	{
		$convEssModel = XenForo_Model::create('ConvEss_Model_ConvEss');
		$convEssModel->batchUpdateLikeUser($oldUserId, $newUserId, $oldUsername, $newUsername);
	}
	
	/**
	 * Gets the name of the template that will be used when listing likes of this type.
	 *
	 * @return string news_feed_item_post_like
	 */
	public function getListTemplateName()
	{
		return 'convess_message_like_feed_item';
	}
}