<?php

class ConvEss_Listener_Cog
{
	// controller class extensions
    public static function loadClassController($class, array &$extend)
    {
        if ($class == 'XenForo_ControllerPublic_Conversation')
        {
            $extend[] = 'ConvEss_ControllerPublic_Conversation';
        }
        else if ($class == 'XenForo_ControllerPublic_InlineMod_Conversation')
        {
            $extend[] = 'ConvEss_ControllerPublic_InlineMod_Conversation';
        }
        else if ($class == 'XenForo_ControllerPublic_Account')
        {
            $extend[] = 'ConvEss_ControllerPublic_Account';
        }
    }
    
    // model class extensions
    public static function loadClassModel($class, array &$extend)
    {
        if ($class == 'XenForo_Model_Conversation')
        {
            $extend[] = 'ConvEss_Model_Conversation';
        }
        else if ($class == 'XenForo_Model_InlineMod_Conversation')
        {
            $extend[] = 'ConvEss_Model_InlineMod_Conversation';
        }
        else if ($class == 'XenForo_Model_User')
        {
            $extend[] = 'ConvEss_Model_User';
        }
        else if ($class == 'XenForo_Model_Like')
        {
            $extend[] = 'ConvEss_Model_Like';
        }
        else if ($class == 'XenForo_Model_AddOn')
        {
            $extend[] = 'ConvEss_Model_AddOn';
        }
    }
    
    // datawriter class extensions
    public static function loadClassDataWriter($class, array &$extend)
    {
        if ($class == 'XenForo_DataWriter_User')
        {
            $extend[] = 'ConvEss_DataWriter_User';
        }
        else if ($class == 'XenForo_DataWriter_ConversationMaster')
        {
            $extend[] = 'ConvEss_DataWriter_ConversationMaster';
        }
     }
     
	// preload the templates
	public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template)
	{
		if ($templateName == 'PAGE_CONTAINER')
		{
			if (isset($params['selectedTabId']) && $params['selectedTabId'] == 'inbox')
			{
				$visitor = XenForo_Visitor::getInstance();
				if ($visitor['user_id'])
				{
					if ($visitor->hasPermission('conversation', 'convessPrefixes'))
						$params['canCreatePrefixes'] = true;
					
					if ($visitor->hasPermission('conversation', 'convessAutoResponse'))
						$params['canAutoRespond'] = true;
					
					if ($visitor->hasPermission('conversation', 'convessParticipantGroups'))
						$params['canCreateGroups'] = true;
				}
			}
		}
		else if ($templateName == 'account_wrapper')
		{
			$template->preloadTemplate('convess_account_wrapper_sidebar_groups');
			$template->preloadTemplate('convess_account_wrapper_sidebar_response');
			$template->preloadTemplate('convess_account_wrapper_sidebar_prefixes');
			$template->preloadTemplate('convess_account_privacy');
		}
		else if ($templateName == 'conversation_view')
		{
			$visitor = XenForo_Visitor::getInstance();
			if ($visitor['user_id'] && $visitor->hasPermission('conversation', 'convessLikeMessages'))
			{
				$template->preloadTemplate('convess_message_controls');
			}
		}
		else if ($templateName == 'account_alert_preferences')
		{
			if (XenForo_Application::get('options')->convess_like_alert_preference)
				$template->preloadTemplate('convess_account_alerts_extra');
		}	
	}
	
	// hook name
	public static function template($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		switch ($hookName)
		{
			case 'account_wrapper_sidebar_conversations':
			{
				self::addConvGroupsLink($contents, $hookParams, $template);
				self::addConvAutoResponseLink($contents, $hookParams, $template);
				self::addConvPrefixLink($contents, $hookParams, $template);
				break;
			}
			case 'account_privacy_bottom':
			{
				self::addPrivacySetting($contents, $hookParams, $template);
				break;
			}
			case 'conversation_message_public_controls':
			{
				self::addLikeLink($contents, $hookParams, $template);
				break;
			}
			case 'account_alerts_extra':
			{
				self::addAccountAlertPreferences($contents, $hookParams, $template);
				break;
			}
		}
	}
	
	// add the like link to conversation messages
	private static function addLikeLink(&$contents, $hookParams, XenForo_Template_Abstract $template)
	{
		$visitor = XenForo_Visitor::getInstance();
		if ($visitor['user_id'] && $visitor->hasPermission('conversation', 'convessLikeMessages'))
		{
			$contents = $template->create('convess_message_controls', $hookParams) . $contents;
		}
	}
	
	// add option to opt out of last read date
	private static function addPrivacySetting(&$contents, $hookParams, XenForo_Template_Abstract $template)
	{
		$options = XenForo_Application::get('options');
		if ($options->convess_last_read_date && $options->convess_last_read_date_privacy)
		{
			$visitor = XenForo_Visitor::getInstance();
			$lastReadLimit = $options->convess_last_read_date_view_limit;
			
			if ($lastReadLimit == 'no_limit' || ($lastReadLimit == 'admins' && $visitor['is_admin']) || ($lastReadLimit == 'admins_mods' && ($visitor['is_admin'] || $visitor['is_moderator'])))
			{
				$conversationModel = XenForo_Model::create('XenForo_Model_Conversation');
				$convessUserOptions = $conversationModel->getConvEssUserOptionsByUserId($visitor['user_id']);
				if (!empty($convessUserOptions))
				{
					$hookParams['allowLastReadDate'] = $convessUserOptions['allow_last_read_date'];
				}
				else
				{
					$hookParams['allowLastReadDate'] = 1;
				}
				
				$contents .= $template->create('convess_account_privacy', $hookParams);
			}
		}
	}
	
	// insert the Conversation Groups link on left side of account page
	private static function addConvGroupsLink(&$contents, $hookParams, XenForo_Template_Abstract $template)
	{
		$visitor = XenForo_Visitor::getInstance();
		if ($visitor['user_id'] && $visitor->hasPermission('conversation', 'convessParticipantGroups'))
		{
        	$hookParams['selectedKey'] = $template->getParam('selectedKey');
			$contents .= $template->create('convess_account_wrapper_sidebar_groups', $hookParams);
		}
	}
	
	// insert the Conversation Groups link on left side of account page
	private static function addConvAutoResponseLink(&$contents, $hookParams, XenForo_Template_Abstract $template)
	{
		$visitor = XenForo_Visitor::getInstance();
		if ($visitor['user_id'] && $visitor->hasPermission('conversation', 'convessAutoResponse'))
		{
        	$hookParams['selectedKey'] = $template->getParam('selectedKey');
			$contents .= $template->create('convess_account_wrapper_sidebar_response', $hookParams);
		}
	}
	
	// insert the Conversation Prefix link on left side of account page
	private static function addConvPrefixLink(&$contents, $hookParams, XenForo_Template_Abstract $template)
	{
		$visitor = XenForo_Visitor::getInstance();
		if ($visitor['user_id'] && $visitor->hasPermission('conversation', 'convessPrefixes'))
		{
        	$hookParams['selectedKey'] = $template->getParam('selectedKey');
			$contents .= $template->create('convess_account_wrapper_sidebar_prefixes', $hookParams);
		}
	}
	
	//  add like alert preferences to the account alert page
	private static function addAccountAlertPreferences(&$contents, $hookParams, XenForo_Template_Abstract $template)
	{
		if (XenForo_Application::get('options')->convess_like_alert_preference)
		{
			$hookParams['alertOptOuts'] = $template->getParam('alertOptOuts');
			$contents = $template->create('convess_account_alerts_extra', $hookParams) . $contents;
		}
	}
}