<?php

/**
 * Model for add-ons.
 *
 * @package ConvEss
 */
class ConvEss_Model_AddOn extends XFCP_ConvEss_Model_AddOn
{
	/**
	 * Installs add-on XML from a simple XML document.
	 *
	 * If an upgrade add-on is given, the XML add-on ID will be checked against if.
	 * If matching, an upgrade will be performed. Otherwise, installing existing add-ons will
	 * be blocked.
	 *
	 * @param SimpleXMLElement $xml
	 * @param string $upgradeAddOnId ID of the add-on to upgrade, if there is one
	 *
	 * @return array List of caches to be built out-of-band with CacheRebuilder
	 */
	public function installAddOnXml(SimpleXMLElement $xml, $upgradeAddOnId = false)
	{
		$install = parent::installAddOnXml($xml, $upgradeAddOnId);
		
		// only works for upgrades as not yet extended on add-on install
		if ($upgradeAddOnId && $upgradeAddOnId == 'ConvEss')
		{
			// delete the TMC templates if the Post Ratings add-on is not installed
			$postRatingExists = $this->getAddOnById('PostRating');
			if (empty($postRatingExists))
			{
				$db = $this->_getDb();
				
				$givenMod = $db->fetchOne('
					SELECT modification_id
					FROM xf_template_modification
					WHERE modification_key = \'convess_dark_postrating_account_ratings_given_1\'
					LIMIT 1
				');
				
				if ($givenMod)
				{
					$writer = XenForo_DataWriter::create('XenForo_DataWriter_TemplateModification', XenForo_DataWriter::ERROR_SILENT);
					$writer->setExistingData($givenMod);
					$writer->delete();
				}
				
				$receivedMod = $db->fetchOne('
					SELECT modification_id
					FROM xf_template_modification
					WHERE modification_key = \'convess_dark_postrating_account_ratings_received_1\'
					LIMIT 1
				');
				
				if ($receivedMod)
				{
					$writer = XenForo_DataWriter::create('XenForo_DataWriter_TemplateModification', XenForo_DataWriter::ERROR_SILENT);
					$writer->setExistingData($receivedMod);
					$writer->delete();
				}
				
				$messageMod = $db->fetchOne('
					SELECT modification_id
					FROM xf_template_modification
					WHERE modification_key = \'convess_message_1\'
					LIMIT 1
				');
				
				if ($messageMod)
				{
					$writer = XenForo_DataWriter::create('XenForo_DataWriter_TemplateModification', XenForo_DataWriter::ERROR_SILENT);
					$writer->setExistingData($messageMod);
					$writer->delete();
				}
			}
		}
		
		return $install;
	}
}