<?php

/**
 * Model for inline action on conversations.
 *
 * @package ConvEss
 */
class ConvEss_Model_InlineMod_Conversation extends XFCP_ConvEss_Model_InlineMod_Conversation
{	

	public function setStickState(array $conversationIds, $state, array $viewingUser = null)
	{
		if (XenForo_Application::get('options')->convess_sticky)

		{
			$this->standardizeViewingUserReference($viewingUser);

			$conversationModel = $this->_getConversationModel();
	
			foreach ($conversationIds AS $conversationId)
		
			{
				
				// assert conversation exists
	
				if ($conversationModel->getConversationForUser($conversationId, $viewingUser['user_id']))
					$conversationModel->setConversationStickyAndOrPrefix($conversationId, $viewingUser['user_id'], $state);
			}
		
		}
	}
	
	public function setLockState(array $conversationIds, $state, array $viewingUser = null)
	{
		
		$state = intval($state);
	
		if ($state > 1)
			
			$state = 1;
	
		
		$this->standardizeViewingUserReference($viewingUser);
	
		$conversationModel = $this->_getConversationModel();
	
		foreach ($conversationIds AS $conversationId)
		
		{
		
			// assert conversation exists and can edit
	
			$conversation = $conversationModel->getConversationForUser($conversationId, $viewingUser['user_id']);

			
			// assert can edit conversation - ie started the conversation
			if ($conversationModel->canEditConversation($conversation))
			
				$conversationModel->setConversationLockState($conversationId, $state);
	
		}
	}
	
	public function setPrefix(array $conversationIds, $prefixId, array $viewingUser = null)
	{
		
		$this->standardizeViewingUserReference($viewingUser);
	
		$conversationModel = $this->_getConversationModel();
	
		$userId = $viewingUser['user_id'];
		
	
		foreach ($conversationIds AS $conversationId)

		{
		
			$conversationModel->setConversationStickyAndOrPrefix($conversationId, $userId, null, $prefixId);

		}
	}	
	
	/**
	 * @return XenForo_Model_Conversation
	 */
	protected function _getConversationModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}

}