<?php

/**
 * Model for users.
 *
 * @package ConvEss
 */
class ConvEss_Model_User extends XFCP_ConvEss_Model_User
{
	/**
	 * Gets all Admins and Mods
	 *
	 * @return array Format: [user id] => user info
	 */
	public function getAdminsAndMods()
	{
		return $this->fetchAllKeyed('
				SELECT user.*, IF (session_activity.view_date IS NULL, user.last_activity, session_activity.view_date) AS effective_last_activity
				FROM xf_user AS user
				LEFT JOIN xf_session_activity AS session_activity ON
						(session_activity.user_id = user.user_id AND session_activity.unique_key = user.user_id)
				WHERE user.is_admin = 1 OR user.is_moderator = 1
		', 'user_id');		
	}
}