<?php
class Dark_Duplicate_ControllerPublic_Post extends XFCP_Dark_Duplicate_ControllerPublic_Post
{
	
	public function actionDuplicate(){
		$postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);		
		$userModel = $this->_getUserModel();
		$postModel = $this->_getPostModel();
		
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId,  array(
			'join' => XenForo_Model_Post::FETCH_USER
		));

		if (!$postModel->canViewIps($post, $thread, $forum, $errorPhraseKey))
		{
			throw $this->getErrorOrNoPermissionResponseException($errorPhraseKey);
		}

		if (!$post['ip_id'])
		{
			return $this->responseError(new XenForo_Phrase('no_ip_information_available'));
		}
		
		$userId = $post['user_id'];
		$ip = $this->getModelFromCache('XenForo_Model_Ip')->getIpById($post['ip_id']);
		
		$viewParams = array(
			'forum' => $forum,
			'thread' => $thread,
			'post' => $post,
			'nodeBreadCrumbs' => $ftpHelper->getNodeBreadCrumbs($forum),
			'user' => $userModel->getUserById($userId),
			'duplicate_users' => $userModel->getUsersByIp($post['ip_id']),
			'ip' => $ip
		);
				
		return $this->responseView('XenForo_ViewPublic_Member_Duplicate', 'dark_duplicate', $viewParams);
	}
	
	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('Dark_Duplicate_Model_User');
	}
}