<?php
class Dark_Duplicate_Model_User extends XenForo_Model_User
{
	
	public function getUsersByIp($ip_id, array $fetchOptions = array()){
		
		if(!$ip_id){
			return array();
		}

		$joinOptions = $this->prepareUserFetchOptions($fetchOptions);
		
		$ip = $this->_getDb()->fetchOne('
			SELECT ip
			from xf_ip
			WHERE ip_id = ?
		', $ip_id);
		
		return $this->fetchAllKeyed('				
			select * from (
				SELECT user.*, ip.log_date
				FROM xf_user AS user
				' . $joinOptions['joinTables'] . '
				left join xf_ip ip on user.user_id = ip.user_id
				WHERE ip.ip = ?
				ORDER BY ip.log_date desc, user.username asc
				) derp
			group by derp.user_id
		', 'user_id', $ip);
		
	}
	
	
}