<?php

/**
 * Forum Age Restriction
 * 
 * @author Vincent Gabriel <vadimg88@gmail.com>
 * @since 01/12/14
 * @version 0.0.1
 */
class ForumAgeRestriction_ControllerPublic_Forum extends XFCP_ForumAgeRestriction_ControllerPublic_Forum
{
	/**
	 * overload the actionForum method to check if we have an age
	 * restriction set
	 * @throws XenForo_ControllerResponse_Exception
	 * @return parent
	 */
	public function actionForum() {
		$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		$forum = $ftpHelper->assertForumValidAndViewable($forumId ? $forumId : $forumName);

		$visitor = XenForo_Visitor::getInstance();
		$permissions = $visitor->getNodePermissions($forumId);

		// Setup
		$fullDate = ForumAgeRestriction_Helper_AgeRestriction::getFullDOBDate($visitor);
		$fullUnix = $fullDate['unix'];

		// Check if there is a minimum set
		if($permissions['ForumAgeRestrictionMinAge'] > 0 || $permissions['ForumAgeRestrictionMaxAge'] > 0) {
			// Check to make sure user has submitted his date of birth
			if(!$visitor['dob_month'] || !$visitor['dob_year']) {
				throw $this->getErrorOrNoPermissionResponseException(new XenForo_Phrase('forum_age_restriction_no_dob_set'));
			}

			// Do we have a minimum set
			if($permissions['ForumAgeRestrictionMinAge'] > 0) {
				if(!!ForumAgeRestriction_Helper_AgeRestriction::validateAge($fullUnix, $permissions['ForumAgeRestrictionMinAge'])) {
					throw $this->getErrorOrNoPermissionResponseException(new XenForo_Phrase('forum_age_restriction_min_not_allowed', array('age' => $permissions['ForumAgeRestrictionMinAge'])));
				}
			}

			// Do we have a maximum set
			if($permissions['ForumAgeRestrictionMaxAge'] > 0) {
				if(!ForumAgeRestriction_Helper_AgeRestriction::validateAge($fullUnix, $permissions['ForumAgeRestrictionMaxAge'])) {
					throw $this->getErrorOrNoPermissionResponseException(new XenForo_Phrase('forum_age_restriction_max_not_allowed', array('age' => $permissions['ForumAgeRestrictionMaxAge'])));
				}
			}
		}

		// Call parent
		return parent::actionForum();
	}
}