<?php
/**
 * Forum Age Restriction
 * 
 * @author Vincent Gabriel <vadimg88@gmail.com>
 * @since 01/12/14
 * @version 0.0.1
 */
class ForumAgeRestriction_Helper_AgeRestriction
{
	/**
	 * Figure out the visitor dob unix and human version
	 * @param array $visitor
	 * @return array
	 */
	public static function getFullDOBDate($visitor) {
		$day = $visitor['dob_day'] ? $visitor['dob_day'] : 1;
		$month = $visitor['dob_month'];
		$year = $visitor['dob_year'];

		// Make sure we have month and year set
		if(!$month || !$year) {
			return false;
		}

		$human = sprintf('%s-%s-%s', $year, $month, $day);
		return array('unix' => strtotime($human), 'human' => $human);
	}

	/**
	 * Validate user age
	 * @param int $unixTime
	 * @param int $age
	 * @return bool
	 */
	public static function validateAge($unixTime, $age) {
	    $min = strtotime(sprintf('+%s years', $age), $unixTime);
	    if(time() < $min)  {
	        return false;
	    }

	    return true;
	}
}