<?php
/**
 * Dice Roller
 * @author Hoffi
 *
 * @category Xenforo Hoffi
 * @subpackage ModViewer
 */
class Hoffi_EventListener_ShowMods
{
    public static function template_create($templateName, array &$params, XenForo_Template_Abstract $template)
    {
        switch ($templateName)
        {
            case 'forum_view':
            case 'thread_view':
            case 'node_forum_level_2':
							$params['showModsInThread'] = XenForo_Application::get('options')->hShowInThread;
							$params['showModsAboveForum'] = in_array(XenForo_Application::get('options')->hShowInForum,array('both','above'));
							$params['showModsBeneathForum'] = in_array(XenForo_Application::get('options')->hShowInForum,array('beneath','both'));
							$params['showModsInMain'] = XenForo_Application::get('options')->hShowInMain;
							if ($params['showModsInThread']
								OR $params['showModsAboveForum'] OR  $params['showModsBeneathForum']
								OR $params ['showModsInMain'])
							{
								$modModel = XenForo_Model::create('XenForo_Model_Moderator');
								if (array_key_exists('thread',$params))
									$node_id = $params['thread']['node_id'];
								else if (array_key_exists('forum',$params))
									$node_id = $params['forum']['node_id'];
								if ($node_id)
								{
									$conditions = array('content' => array('node', $params['forum']['node_id']));
									$params['moderators'] = $modModel->getContentModerators($conditions);
									$params['modCount'] = count($params['moderators']);
								}
								else
								{
									$params['modCount'] = 0;
								}
							}
              break;
        }
    }

}