<?php

class Insy_MultipleAccounts_Actions
{
	/** @var array */
	protected $_options;
	
	/** @var XenForo_Visitor */
	protected $_visitor;
	
	public function run()
	{
		$this->_options = XenForo_Application::getOptions()->get('isd_actions');
		$this->_visitor = XenForo_Visitor::getInstance();
		
		if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH']))
			echo '<!-- MULTIPLE ACCOUNTS DETECTED -->';
		
		if ( $this->_options['ban'] )
			$this->runBan();
		
		if ( $this->_options['banip'] )
			$this->runBanIp();
		
		if ( $this->_options['banall'] )
			$this->runBanAll();
		
		if ( $this->_options['ban'] || $this->_options['banip'] || $this->_options['banall'] )
			$this->_visitor['is_banned'] = true;
		
		if ( $this->_options['discouragement'] )
			$this->runDiscourage();
		
		if ( $this->_options['conversation'] )
			$this->runConversation();
	}
	
	/**
	 * Ban the current account
	 */
	protected function runBan()
	{
		$userModel 	= $this->_getUserModel();		
		$reason 	= XenForo_Application::getOptions()->get('isd_ban_reason');
		$success 	= $userModel->ban(XenForo_Visitor::getUserId(), XenForo_Model_User::PERMANENT_BAN, $reason);
	}
	
	/**
	 * Ban the current IP
	 */
	protected function runBanIp()
	{
		if ( isset($_SERVER['REMOTE_ADDR']) )
		{
			$ip = $_SERVER['REMOTE_ADDR'];
			$this->_getBanningModel()->banIp($ip);
		}
	}
	
	/**
	 * Ban all accounts with this IP
	 */
	protected function runBanAll()
	{
		if ( isset($_SERVER['REMOTE_ADDR']) )
		{
			$ip 		= $_SERVER['REMOTE_ADDR'];
			$userModel	= $this->_getUserModel();
			$ago 		= XenForo_Application::getOptions()->get('isd_days_ago');
			$reason 	= XenForo_Application::getOptions()->get('isd_ban_reason');
			$success	= true;
			
			foreach ( $userModel->getUsersByIpAndLogDate($ip, array(
					Insy_MultipleAccounts_Model_User::LOG_DATE	=>
						 $ago['permanent'] ? 0 : intval($ago['custom']),
			)) as $user )
				$success ^= $userModel->ban($user['user_id'], XenForo_Model_User::PERMANENT_BAN, $reason);
			
			return $success;
		}
	}
	
	/**
	 * Discourage the IP
	 */
	protected function runDiscourage()
	{
		if ( isset($_SERVER['REMOTE_ADDR']) )
		{
			$banningModel = $this->_getBanningModel();
			$success = $banningModel->discourageIp($_SERVER['REMOTE_ADDR']);
		}
	}
	
	/**
	 * Start a conversation
	 */
	protected function runConversation()
	{
		$options = XenForo_Application::getOptions();
		
		$message = $options->get('isd_conversation_text');
		$title	 = $options->get('isd_conversation_title');
		$sender	 = $options->get('isd_conversation_sender');
		$lock	 = $options->get('isp_conversation_lock');
		$ago	 = $options->get('isd_days_ago');
		
		// Ensure that we open only one conversation
		$conversationModel = $this->_getConversationModel();
		$result = $conversationModel->countConversationsForBanning(
			$title, $ago['permanent'] ? 0 : intval($ago['custom']), $sender
		);
		if ( $result ) return ;
		
		$message = str_replace('{username}', XenForo_Visitor::getInstance()->get('username'), $message);
		$message = str_replace('{boardTitle}', $options->get('boardTitle'), $message);
		$message = str_replace('{contactUrl}', '[URL]' .
				(($options->contactUrl['type'] == 'custom') ?
					$options->contactUrl['custom'] :
						($options->get('boardUrl') . '/' . XenForo_Link::buildPublicLink('index'))) . '[/URL]', $message);
		$message = XenForo_Helper_String::autoLinkBbCode($message);
		
		if (false == ($sender = $this->_getUserModel()->getUserById($sender)))
			if (false == ($sender = $this->_getUserModel()->getUserById(1)))
				return false;
		
		/* @var $conversationDw XenForo_DataWriter_ConversationMaster */
		$conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster');
		$conversationDw->setExtraData(XenForo_DataWriter_ConversationMaster::DATA_ACTION_USER, $sender);
		$conversationDw->setExtraData(XenForo_DataWriter_ConversationMaster::DATA_MESSAGE, $message);
		$conversationDw->set('user_id', $sender['user_id']);
		$conversationDw->set('username', $sender['username']);
		$conversationDw->set('title', $title);
		$conversationDw->set('open_invite', false);
		$conversationDw->set('conversation_open', ! $lock);
		$conversationDw->addRecipientUserIds(array(XenForo_Visitor::getUserId()));
		
		$messageDw = $conversationDw->getFirstMessageDw();
		$messageDw->set('message', $message);
		
		$conversationDw->preSave();
		$conversationDw->save();
	}
	
	/**
	 * @return Insy_MultipleAccounts_Model_User
	 */
	protected function _getUserModel()
	{
		static $model;
		
		if ( false == $model instanceof Insy_MultipleAccounts_Model_User )
			$model = XenForo_Model::create('Insy_MultipleAccounts_Model_User');
	
		return $model;
	}
	
	/**
	 * @return XenForo_Model_Banning
	 */
	protected function _getBanningModel()
	{
		static $model;
	
		if ( false == $model instanceof XenForo_Model_Banning )
			$model = XenForo_Model::create('XenForo_Model_Banning');
	
		return $model;
	}
	
	/**
	 * @return Insy_MultipleAccounts_Model_Conversation
	 */
	protected function _getConversationModel()
	{
		static $model; 
		
		if ( false == $model instanceof Insy_MultipleAccounts_Model_Conversation )
			 $model = XenForo_Model::create('Insy_MultipleAccounts_Model_Conversation');
		
		return $model;
	}
}