<?php

abstract class Insy_MultipleAccounts_Listeners
{
	public static function onVisitorSetup(XenForo_Visitor &$visitor)
	{
		$detector = new Insy_MultipleAccounts_Detector();
		$actions  = new Insy_MultipleAccounts_Actions();
		
		// Save the user agent
		if (
			XenForo_Visitor::getUserId() &&
			$checks = XenForo_Application::getOptions()->get('isp_additional_checks') &&
			$checks['browser']
		) {
			/* @var $userModel Insy_MultipleAccounts_Model_User */
			$userModel = XenForo_Model::create('Insy_MultipleAccounts_Model_User');
			$userModel->updateUserAgent(XenForo_Visitor::getUserId(), $detector->getUserAgent());
		}
		
		// Run the detector
		$result = $detector->isMultipleAccount();
		
		// We've got it!
		if ( $result )
			$actions->run();
	}
}