<?php

class Insy_MultipleAccounts_Model_Conversation extends XenForo_Model_Conversation
{
	public function countConversationsForBanning( $title, $daysAgo, $sender )
	{
		if ( $daysAgo == 0 )
		{
			$startDate = 'start_date';
		}
		else
		{
			$startDate = strtotime('-' . $daysAgo .' day', XenForo_Application::$time);
		}
		
		$count = $this->_getDb()->fetchOne('
			SELECT COUNT(*) AS conversation_count
			FROM xf_conversation_master AS c
			WHERE	c.user_id 	= ? ' . '
				AND c.title		LIKE(?) ' .
				($startDate ? ('AND start_date >= ' . $startDate) : '')
		, array(
			intval($sender),
			$title
		));
		
		return $count;
	}
}