<?php

class Insy_MultipleAccounts_Model_User extends XenForo_Model_User
{
	const 	ALREADY_BANNED		= 1,
			LOG_DATE			= 2,
			USER_AGENT			= 3;
	
	public function getUsersByIpAndLogDate($ip, $fetchOptions = array())
	{
		$ip = XenForo_Helper_Ip::convertIpStringToBinary($ip);
		if (!$ip)
		{
			return array();
		}
		
		$conditions = array('ip.ip = ' . $this->_getDb()->quote($ip));
		
		if ( isset($fetchOptions[self::LOG_DATE])
			&& is_integer($fetchOptions[self::LOG_DATE])
			&&	$fetchOptions[self::LOG_DATE] > 0 )
		{
			$logDate = strtotime('-' . $fetchOptions[self::LOG_DATE] .' day', XenForo_Application::$time);
		}
		
		$isdJoinType = 'LEFT';
		
		if ( isset($fetchOptions[self::USER_AGENT]) 
			&& $fetchOptions[self::USER_AGENT] )
		{
			$isdJoinType = 'INNER';
			$conditions[] = 'user_agent = ' . $this->_getDb()->quote(substr($fetchOptions[self::USER_AGENT], 0, 250));
		}
		
		$bannedJoinType = 'LEFT';
		
		if ( isset($fetchOptions[self::ALREADY_BANNED])
			&& $fetchOptions[self::ALREADY_BANNED] )
		{
			$bannedJoinType = 'INNER';
		}
		
		return $this->_getDb()->fetchAll('
			SELECT u.user_id, u.username,
				isd.user_agent,
				IF(ban.ban_user_id, TRUE, FALSE) AS banned,
			    MAX(ip.log_date) AS log_date
			FROM xf_ip ip
			INNER JOIN xf_user u ON ip.user_id = u.user_id
			' . $bannedJoinType .' JOIN xf_user_ban ban ON ip.user_id = ban.user_id
			' . $isdJoinType . ' JOIN isd_user_log isd ON ip.user_id = isd.user_id
			WHERE ' . implode(' AND ', $conditions) . '
			GROUP BY ip.user_id
		');
		
		return $this->_getDb()->fetchAll('
			SELECT u.user_id, u.username,
				isd.user_agent,
				IF(ban.ban_user_id, TRUE, FALSE) AS banned,
			    MAX(ip.log_date) AS log_date
			FROM xf_ip ip
			INNER JOIN xf_user u ON ip.user_id = u.user_id
			' . $bannedJoinType .' JOIN xf_user_ban ban ON ip.user_id = ban.user_id
			' . $isdJoinType . ' JOIN isd_user_log isd ON ip.user_id = isd.user_id
			WHERE ' . implode(' AND ', $conditions) . '
			GROUP BY ip.user_id
		');
	}
	
	public function updateUserAgent($userId, $userAgent)
	{
		$userId = $this->_getDb()->quote($userId, 'INT');
		$userAgent = $this->_getDb()->quote(substr($userAgent, 0, 250));
		
		$this->_getDb()->query('
			INSERT INTO isd_user_log (user_id, user_agent)
			VALUES (' . $userId . ', ' . $userAgent . ')
			ON DUPLICATE KEY UPDATE user_agent = ' . $userAgent
		);
	}
}