<?php

class LiamW_AdminCPFirewall_Extend_ControllerAdmin_Login extends XFCP_LiamW_AdminCPFirewall_Extend_ControllerAdmin_Login
{

	public function actionLogin()
	{
		$options = XenForo_Application::get('options');
		$ip = LiamW_AdminCPFirewall_Tools::getIp();

		$data = $this->_input->filter(array(
			'login' => XenForo_Input::STRING,
			'password' => XenForo_Input::STRING,
			'redirect' => XenForo_Input::STRING,
			'cookie_check' => XenForo_Input::UINT
		));

		$userModel = $this->_getUserModel();

		$userId = $userModel->validateAuthentication($data['login'], $data['password']);
		$user = $userModel->getUserById($userId);

		if ($user)
		{
			$userLink = XenForo_Link::buildAdminLink('full:users/edit', $user);
		}
		else
		{
			$userLink = false;
		}

		if (!$userId)
		{
			if ($options->cpfirewall_emailfailedlogin)
			{
				$subject = new XenForo_Phrase('cpfirewall_cpfailedlogin_subject');

				if ($userLink)
				{
					$body = new XenForo_Phrase('cpfirewall_cpfailedlogin_body_user', array(
						'ip' => $ip,
						'name' => $data['login'],
						'userLink' => $userLink
					));
				}
				else
				{
					$body = new XenForo_Phrase('cpfirewall_cpfailedlogin_body', array(
						'ip' => $ip,
						'name' => $data['login']
					));
				}

				$emailAddresses = explode("\n", str_replace(array(
					"\r\n",
					"\r",
					"\n"
				), "\n", $options->cpfirewall_emails));

				$email = new XenForo_Mail('cpfirewall_email', array(
					'subject' => $subject,
					'bodyHtml' => $body,
					'bodyText' => $body
				));

				foreach ($emailAddresses as $address)
				{
					$email->send($address);
				}
			}

			return parent::actionLogin();
		}

		if (!$user['is_admin'] && $options->cpfirewall_emailnonadminlogin)
		{
			$subject = new XenForo_Phrase('cpfirewall_cpnonadminlogin_subject');
			$body = new XenForo_Phrase('cpfirewall_cpnonadminlogin_body', array(
				'name' => $data['login'],
				'ip' => $ip,
				'userLink' => $userLink
			));

			$emailAddresses = $this->getEmailAddresses();

			$email = new XenForo_Mail('cpfirewall_email', array(
				'subject' => $subject,
				'bodyHtml' => $body,
				'bodyText' => strip_tags($body),
			));

			foreach ($emailAddresses as $emailAddress)
			{
				$email->send($emailAddress);
			}
		}

		if (!LiamW_AdminCPFirewall_Tools::IPAllowed($options))
		{
			if ($options->cpfirewall_ipemail)
			{
				$subject = new XenForo_Phrase('cpfirewall_cpinvalidip_subject');
				$body = new XenForo_Phrase('cpfirewall_cpinvalidip_body', array(
					'name' => $data['login'],
					'ip' => $ip,
					'userLink' => $userLink
				));
				$emailAddresses = $emailAddresses = $this->getEmailAddresses();

				$email = new XenForo_Mail('cpfirewall_email', array(
					'subject' => $subject,
					'bodyHtml' => $body,
					'bodyText' => strip_tags($body)
				));

				foreach ($emailAddresses as $address)
				{
					$email->send($address);
				}
			}

			if ($options->cpfirewall_ipdeny && !defined('DISABLEIPDENY'))
			{
				return $this->responseError(new XenForo_Phrase('ip_not_allowed'));
			}
		}

		if ($options->cpfirewall_loginemail)
		{
			$name = XenForo_Visitor::setup($userId)->get('username');
			$subject = new XenForo_Phrase('cpfirewall_cplogin_subject');
			$body = new XenForo_Phrase('cpfirewall_cplogin_body', array(
				'ip' => $ip,
				'name' => $name,
				'userLink' => $userLink
			));
			$emailAddresses = $this->getEmailAddresses();

			$email = new XenForo_Mail('cpfirewall_email', array(
				'subject' => $subject,
				'bodyHtml' => $body,
				'bodyText' => strip_tags($body)
			));

			foreach ($emailAddresses as $address)
			{
				$email->send($address);
			}
		}

		return parent::actionLogin();
	}

	protected function getEmailAddresses()
	{
		$options = XenForo_Application::getOptions();

		return explode("\n", str_replace(array(
			"\r\n",
			"\r",
			"\n"
		), "\n", $options->cpfirewall_emails));
	}

}