<?php

/**
 * Tools class. Contains functions used by other classes.
 *
 * @author Liam
 *
 */
class LiamW_AdminCPFirewall_Tools
{
	private static $_instance = null;

	/**
	 * Returns dynamically resolved instance of this class, or null in the case of an error.
	 *
	 * @return null|LiamW_AdminCPFirewall_Tools
	 */
	public static function getInstance()
	{
		if (!self::$_instance)
		{
			$class = XenForo_Application::resolveDynamicClass(__CLASS__);

			if ($class)
			{
				self::$_instance = new $class();
			}
		}

		return self::$_instance;
	}

	/**
	 * Protected constructor. Use getInstance() method.
	 */
	protected function __construct()
	{

	}

	/**
	 * Checks if the user IP matches any of the IP's in the options.
	 *
	 * @param XenForo_Options $options XenForo Options Class
	 *
	 * @return boolean Returns true if any of the IP's match or false if not.
	 */
	public static function IPAllowed(XenForo_Options $options = null)
	{
		if ($options == null)
		{
			$options = XenForo_Application::getOptions();
		}

		if (($options->cpfirewall_ipdeny || $options->cpfirewall_ipemail))
		{
			$ips = array_filter(explode("\n", str_replace(array(
				"\r\n",
				"\r",
				"\n"
			), "\n", $options->cpfirewall_ips)));

			$match = false;

			foreach ($ips as $ip)
			{
				$ipArray = array_filter(explode('.', $ip));

				if (count($ipArray) === 4)
				{
					// full ip
					if ($ip !== self::getIp())
					{
						$match = false;
					}
					else
					{
						$match = true;
						break;
					}
				}
				else
				{
					// partial ip
					$explodedIp = explode('.', self::getIp());
					$explodedIp = array_splice($explodedIp, 0, count($ipArray), true);
					if ($explodedIp === $ipArray)
					{
						$match = true;
						break;
					}
					else
					{
						$match = false;
					}
				}
			}

			return $match;
		}
		else
		{
			return false;
		}
	}

	/**
	 * Finds the users IP using proxy headers if present.
	 *
	 * @return string The user's IP.
	 */
	public static function getIp()
	{
		if (array_key_exists('HTTP_X_FORWARDED_FOR', $_SERVER) && !empty($_SERVER['HTTP_X_FORWARDED_FOR']))
		{
			if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') > 0)
			{
				$addr = explode(",", $_SERVER['HTTP_X_FORWARDED_FOR']);
				return trim($addr[0]);
			}
			else
			{
				return $_SERVER['HTTP_X_FORWARDED_FOR'];
			}
		}
		else
		{
			return $_SERVER['REMOTE_ADDR'];
		}
	}
}