<?php
namespace LiamW\LotsaBots\ControllerAdmin;

class Robots extends \XenForo_ControllerAdmin_Abstract
{

	public function actionIndex()
	{
		$robots = $this->_getRobotsModel()->getAllRobots();
		
		$viewParams = array(
			'robots' => $robots
		);
		
		return $this->responseView('', 'liam_robots_list', $viewParams);
	}

	public function actionAdd()
	{
		return $this->responseView('', 'liam_robots_edit');
	}

	public function actionEdit()
	{
		$robotId = $this->_input->filterSingle('robot_id', \XenForo_Input::UINT);
		
		$robot = $this->_getRobotsModel()->getRobotById($robotId);
		
		if (! $robot)
		{
			return $this->responseError(new \XenForo_Phrase('liam_robots_not_found'), 404);
		}
		
		$viewParams = array(
			'robot' => $robot
		);
		
		return $this->responseView('', 'liam_robots_edit', $viewParams);
	}

	public function actionSave()
	{
		$robotId = $this->_input->filterSingle('robot_id', \XenForo_Input::UINT);
		
		$data = $this->_input->filter(array(
			'name' => \XenForo_Input::STRING,
			'link' => \XenForo_Input::STRING,
			'user_agent' => \XenForo_Input::STRING
		));
		
		$dw = \XenForo_DataWriter::create('LiamW\LotsaBots\DataWriter\Robots');
		
		if ($robotId)
		{
			$dw->setExistingData($robotId, true);
		}
		
		$dw->bulkSet($data);
		
		$dw->save();
		
		$lastHash = $this->getLastHash($dw->get('robot_id'));
		
		return $this->responseRedirect(\XenForo_ControllerResponse_Redirect::SUCCESS, \XenForo_Link::buildAdminLink('robots') . $lastHash);
	}

	public function actionDelete()
	{
		$robotId = $this->_input->filterSingle('robot_id', \XenForo_Input::UINT);
		
		if ($this->isConfirmedPost())
		{
			$dw = \XenForo_DataWriter::create('LiamW\LotsaBots\DataWriter\Robots');
			$dw->setExistingData($robotId, true);
			$dw->delete();
			
			return $this->responseRedirect(\XenForo_ControllerResponse_Redirect::SUCCESS, \XenForo_Link::buildAdminLink('robots'));
		}
		else
		{
			$robot = $this->_getRobotsModel()->getRobotById($robotId);
			
			$viewParams = array(
				'robot' => $robot
			);
			
			return $this->responseView('', 'liam_robots_delete', $viewParams);
		}
	}

	public function actionExport()
	{
		if ($this->isConfirmedPost())
		{
			$robots = $this->_input->filterSingle('robot_ids', array(
				\XenForo_Input::UINT,
				'array' => true
			));
			
			if (sizeof($robots) < 1)
			{
				return $this->responseError(new \XenForo_Phrase('liam_robots_none_selected_for_export'));
			}
			
			$this->_routeMatch->setResponseType('xml');
			
			$viewParams = array(
				'xml' => $this->_getRobotsModel()->exportRobots($robots)
			);
			
			return $this->responseView('LiamW\LotsaBots\ViewAdmin\Robots\Export', '', $viewParams);
		}
		else
		{
			$robots = $this->_getRobotsModel()->getAllRobots();
			
			if (sizeof($robots) < 1)
			{
				return $this->responseError(new \XenForo_Phrase('liam_robots_none_to_export'));
			}
			
			$viewParams = array(
				'robots' => $robots
			);
			
			return $this->responseView('', 'liam_robots_export', $viewParams);
		}
	}

	public function actionImport()
	{
		if ($this->isConfirmedPost())
		{
			$file = \XenForo_Upload::getUploadedFile('file');
			
			$response = $this->_getRobotsModel()->importRobots($file);
			
			if (! $response)
			{
				return $this->responseMessage(new \XenForo_Phrase('liam_robots_some_may_failed'));
			}
			
			return $this->responseRedirect(\XenForo_ControllerResponse_Redirect::SUCCESS, \XenForo_Link::buildAdminLink('robots'));
		}
		else
		{
			return $this->responseView('', 'liam_robots_import_form');
		}
	}

	/**
	 *
	 * @return \LiamW\LotsaBots\Model\Robots
	 */
	protected function _getRobotsModel()
	{
		return $this->getModelFromCache('LiamW\LotsaBots\Model\Robots');
	}

}


