<?php
namespace LiamW\LotsaBots\DataWriter;

class Robots extends \XenForo_DataWriter
{
	/*
	 * (non-PHPdoc) @see XenForo_DataWriter::_getFields()
	 */
	protected function _getFields()
	{
		return array(
			'liam_robots' => array(
				'robot_id' => array(
					'type' => self::TYPE_UINT,
					'autoIncrement' => true
				),
				'name' => array(
					'type' => self::TYPE_STRING,
					'maxLength' => 50,
					'required' => true
				),
				'link' => array(
					'type' => self::TYPE_STRING,
					'maxLength' => 255,
					'required' => true
				),
				'user_agent' => array(
					'type' => self::TYPE_STRING,
					'maxLength' => 255,
					'required' => true,
					'verification' => array(
						'$this',
						'_verifyUserAgent'
					)
				)
			)
		);
	}
	
	/*
	 * (non-PHPdoc) @see XenForo_DataWriter::_getExistingData()
	 */
	protected function _getExistingData($data)
	{
		if (! $id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}
		
		return array(
			'liam_robots' => $this->_getRobotsModel()->getRobotById($id)
		);
	}
	
	/*
	 * (non-PHPdoc) @see XenForo_DataWriter::_getUpdateCondition()
	 */
	protected function _getUpdateCondition($tableName)
	{
		return "robot_id = " . $this->_db->quote($this->getExisting('robot_id'));
	}

	protected function _verifyUserAgent($userAgent)
	{
		if (! preg_match('/[A-Za-z0-9]/', $userAgent))
		{
			$this->error(new \XenForo_Phrase('liam_robots_ua_alphanumeric'), 'user_agent');
		}
		
		return true;
	}

	/**
	 *
	 * @return \LiamW\LotsaBots\Model\Robots
	 */
	protected function _getRobotsModel()
	{
		return $this->getModelFromCache('LiamW\LotsaBots\Model\Robots');
	}

}