<?php
namespace LiamW\LotsaBots\Model;

use LiamW\LotsaBots\Addon;

class Robots extends \XenForo_Model
{

	public function getAllRobots()
	{
		return $this->fetchAllKeyed("SELECT * FROM liam_robots", 'robot_id');
	}

	public function getRobotById($id)
	{
		return $this->_getDb()->fetchRow("SELECT * FROM liam_robots WHERE robot_id=?", array(
			$id
		));
	}

	public function getRobotsByIds(array $ids)
	{
		return $this->fetchAllKeyed("SELECT * FROM liam_robots WHERE robot_id IN ( " . $this->_getDb()
			->quote($ids) . ")", 'robot_id');
	}

	public function getRobotsForArray()
	{
		$allBots = $this->getAllRobots();
		
		$return = array();
		
		foreach ($allBots as $bot)
		{
			$return[strtolower($bot['user_agent'])] = 'custom_' . $bot['robot_id'];
		}
		
		return $return;
	}

	public function getRobotsInfoArray()
	{
		$allBots = $this->getAllRobots();
		
		$return = array();
		
		foreach ($allBots as $bot)
		{
			$return['custom_' . $bot['robot_id']] = array(
				'title' => $bot['name'],
				'link' => $bot['link']
			);
		}
		
		return $return;
	}

	public function exportRobots(array $robotIds)
	{
		if (empty($robotIds))
		{
			throw new \XenForo_Exception('Robot ids cannot be empty!');
		}
		
		$document = new \DOMDocument('1.0', 'utf-8');
		$document->formatOutput = true;
		
		$rootNode = $document->createElement('robots');
		$rootNode->setAttribute('version', Addon::VERSION_CODE);
		$document->appendChild($rootNode);
		
		$robots = $this->getRobotsByIds($robotIds);
		
		ksort($robots);
		
		foreach ($robots as $robot)
		{
			$robotNode = $document->createElement('robot');
			$robotNode->setAttribute('name', $robot['name']);
			$robotNode->setAttribute('link', $robot['link']);
			$robotNode->setAttribute('user_agent', $robot['user_agent']);
			
			$rootNode->appendChild($robotNode);
		}
		
		return $document;
	}

	public function importRobots(\XenForo_Upload $file)
	{
		$fileName = $file->getTempFile();
		
		if (! file_exists($fileName) || ! is_readable($fileName))
		{
			throw new \XenForo_Exception(new \XenForo_Phrase('liam_robots_invalid_file'), true);
		}
		
		try
		{
			$document = new \SimpleXMLElement($fileName, 0, true);
		}
		catch (\Exception $e)
		{
			throw new \XenForo_Exception(new \XenForo_Phrase('liam_robots_file_not_valid_xml'), true);
		}
		
		return $this->_importXml($document);
	}

	protected function _importXml(\SimpleXMLElement $xml)
	{
		if ($xml->getName() != 'robots')
		{
			throw new \XenForo_Exception(new \XenForo_Phrase('liam_robots_file_not_robots_file'), true);
		}
		
		if ((int) $xml['version'] > Addon::VERSION_CODE)
		{
			throw new \XenForo_Exception(new \XenForo_Phrase('liam_robots_file_from_newer_version'), true);
		}
		

		$db = $this->_getDb();
		
		\XenForo_Db::beginTransaction($db);
		
		$robotXml = \XenForo_Helper_DevelopmentXml::fixPhpBug50670($xml);
		
		$response = true;
		
		foreach ($robotXml as $robot)
		{
			$dw = \XenForo_DataWriter::create('LiamW\LotsaBots\DataWriter\Robots', \XenForo_DataWriter::ERROR_SILENT);
			$data = array(
				'name' => (string) $robot['name'],
				'link' => (string) $robot['link'],
				'user_agent' => (string) $robot['user_agent']
			);
			$dw->bulkSet($data);
			$dw->save();
			
			if ($dw->hasErrors())
			{
				$response = false;
			}
		}
		
		\XenForo_Db::commit($db);
		
		return $response;
	}

}