<?php

class LoginUserLocks_ControllerPublic_Login extends XFCP_LoginUserLocks_ControllerPublic_Login
{

	
	public function actionLogin()
	{
		
		// for sent username/email, check that recent attempts
		
	
		$data = $this->_input->filter(array(
			'login' => XenForo_Input::STRING,
		));
		
		$options = XenForo_Application::get('options');
		$numberOfAttempts = $options->numberOfAttempts;
		$lockExpiry = $options->lockExpiry;
		
		$LULLogin = $this->_getLULLoginModel();
		$countLoginAttempts = $LULLogin->countLoginAttempts($data['login'], $lockExpiry);
		$time_remaining = $lockExpiry - (time() - $LULLogin->getOldestAttemptDate($data['login'], $lockExpiry));

		
		if ($countLoginAttempts >= $numberOfAttempts)
		{
			//return $this->responseError(new XenForo_Phrase('lul_your_account_has_been_locked_for_x_you_have_y_remaining', array('lockExpiry' => $lockExpiry, 'time_remaining' => $time_remaining)));
			//return $this->responseError(new XenForo_Phrase('your_account_has_temporarily_been_locked_due_to_failed_login_attempts'));	
			
			
			$viewParams = array(
				'lockExpiry' => $lockExpiry,
				'time_remaining' => $time_remaining,
				'path' => $options->boardUrl
			);
	
			$containerParams = array(
				'containerTemplate' => 'LOGIN_PAGE'
			);

			return $this->responseView('XenForo_ViewPublic_Login', 'lul_locked_account', $viewParams);	
			
		}
		
		else {
			$responseView = parent::actionLogin(); 
			return $responseView;		
		}
		
		
	}

	protected function _getLULLoginModel()
	{
		return $this->getModelFromCache('LoginUserLocks_Model_Login');
	}	
		
}
