<?php

class LoginUserLocks_Model_Login extends XenForo_Model
{
	public function countLoginAttempts($usernameOrEmail, $lockExpire, $ipAddress = null)
	{
		$ipAddress = $this->convertIpToLong($ipAddress);

		$cutOff = XenForo_Application::$time - $lockExpire;

		return $this->_getDb()->fetchOne('
			SELECT COUNT(*)
			FROM xf_login_attempt
			WHERE login = ?
				AND ip_address = ?
				AND attempt_date > ?
		', array($usernameOrEmail, $ipAddress, $cutOff));
	}

	
		public function getOldestAttemptDate($usernameOrEmail, $lockExpire, $ipAddress = null)
	{
		$ipAddress = $this->convertIpToLong($ipAddress);

		$cutOff = XenForo_Application::$time - $lockExpire;

		return $this->_getDb()->fetchOne('
			SELECT attempt_date
			FROM xf_login_attempt
			WHERE login = ?
				AND ip_address = ?
				AND attempt_date > ?
			ORDER By attempt_date DESC
			LIMIT 1
		', array($usernameOrEmail, $ipAddress, $cutOff));
	}
	
	
	public function convertIpToLong($ipAddress = null)
	{
		if ($ipAddress === null)
		{
			$ipAddress = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 0);
		}

		if (is_string($ipAddress) && strpos($ipAddress, '.'))
		{
			$ipAddress = ip2long($ipAddress);
		}

		return sprintf('%u', $ipAddress);
	}
	
		
}