<?php

/*
 *  Merc Common Library
 *  Helper.php 0.3
 *  (this library added like this so I don't have to worry about backwards compatability)
 *
 *  Static helpers that can/might be used between add-ons.
 */

$folder = basename(dirname(dirname(__FILE__)));
require_once XenForo_Application::getInstance()->getRootDir() . '/library/Merc/' . $folder . '/Common/Base.php';
// Note: eval at bottom of file

if ( ! class_exists('Merc_Common_Helper_Version03'))
{
	class Merc_Common_Helper_Version03 extends Merc_Common_Base_Version03
	{
		/**
		 * Used to promote users without waiting for the cron to run or calling the cron.
		 * Basically does the same thing as the cron but only for the specified users.
		 *
		 * @param  array|int $userIds - array of user IDs, if int is sent will treat it as array($userIds)
		 * @return void
		 */
		public static function promoteUsers($userIds)
		{
			if ( ! is_array($userIds))
			{
				$userIds = array($userIds);
			}

			$promotionModel = XenForo_Model::create('XenForo_Model_UserGroupPromotion');
			$promotions = $promotionModel->getPromotions(array(
				'active' => 1
			));
			if ( ! $promotions)
			{
				return;
			}

			$userModel = XenForo_Model::create('XenForo_Model_User');
			$users = $userModel->getUsersByIds($userIds, array('join' => XenForo_Model_User::FETCH_USER_FULL));
			$userPromotionStates = $promotionModel->getPromotionStatesByUserIds(array_keys($users));

			foreach ($users AS $userId => $user)
			{
				foreach ($promotions AS $promotionId => $promotion)
				{
					$hasPromotion = false;
					if (isset($userPromotionStates[$userId][$promotionId]))
					{
						// These 2 states need to be skipped
						if (in_array($userPromotionStates[$userId][$promotionId], array('manual', 'disabled')))
						{
							continue;
						}

						$hasPromotion = true;
					}

					if (XenForo_Helper_Criteria::userMatchesCriteria($promotion['user_criteria'], false, $user))
					{
						if (!$hasPromotion)
						{
							$promotionModel->promoteUser($promotion, $userId);
						}
					}
					else
					{
						$promotionModel->demoteUser($promotion, $userId);
					}
				}
			}
		}
	}
}

eval('abstract class Merc_' . $folder . '_Common_Helper extends Merc_Common_Helper_Version03 {}');
