<?php

/*
 *  Merc Common Library
 *  Installer.php 0.3
 *  (this library added like this so I don't have to worry about backwards compatability)
 *
 *  This class is used to easily create an inremental installer.
 *  Runs install(...) on first install and then after that _upgradeVersionX(...) where X is the add-on version ID.
 *  Designed not to do too much to leave the developer writing out queries in full to reduce errors made by this library.
 */

$folder = basename(dirname(dirname(__FILE__)));
require_once XenForo_Application::getInstance()->getRootDir() . '/library/Merc/' . $folder . '/Common/Base.php';
// Note: eval at bottom of file

if (!class_exists('Merc_Common_Installer_Version03'))
{
	abstract class Merc_Common_Installer_Version03 extends Merc_Common_Base_Version03
	{
		protected $_existingAddon = null;

		protected $_addonData = null;

		protected $_tables = null;

		protected $_contentTypes = null;

		protected $_processedLog = array();

		public function __construct($existingAddon, $addonData = null)
		{
			// Database will always be used so make sure it is there so we can use the shorter $this->_db instead
			$this->_getDb();

			$this->_existingAddon = $existingAddon;
			$this->_addonData = $addonData;
		}

		protected function _install()
		{
			$this->_installFromData();
		}

		protected function _installFromData()
		{
			if ( ! empty($this->_tables))
			{
				foreach ($this->_tables AS $table => $data)
				{
					$engine = 'InnoDB';
					if (strpos($table, ':') !== false)
					{
						list ($table, $engine) = explode(':', $table);
					}

					$this->_createTable($table, $data, $engine);
				}
			}

			if ( ! empty($this->_contentTypes))
			{
				$this->_insertContentTypes($this->_contentTypes);
			}
		}

		protected function _createTable($table, $data, $engine = 'InnoDB')
		{
			$this->_db->query("
				CREATE TABLE IF NOT EXISTS $table (
					$data
				) ENGINE = $engine CHARACTER SET utf8 COLLATE utf8_general_ci
			");

			$this->_processedLog['created'][] = $table;
		}

		protected function _insertContentTypes($contentTypes)
		{
			$sql = '
				INSERT IGNORE INTO xf_content_type
					(content_type, addon_id, fields)
				VALUES';
			$logs = array();
			foreach (array_keys($this->_contentTypes) AS $contentType)
			{
				$sql .= "
					('$contentType', '" . $this->_addonData['addon_id'] . "', ''),";
				$logs[] = 'content_type = ' . $this->_db->quote($contentType);
			}

			$this->_db->query(substr($sql, 0, -1));
			$this->_processedLog['inserted']['xf_content_type'] = $logs;

			$sql = '
				INSERT IGNORE INTO xf_content_type_field
					(content_type, field_name, field_value)
				VALUES';
			$logs = array();
			foreach ($contentTypes AS $contentType => $fields)
			{
				foreach ($fields AS $name => $value)
				{
					$sql .= "
					('$contentType', '$name', '$value'),";
					$logs[] = '
						content_type = ' . $this->_db->quote($contentType) . ' AND
						field_name = ' . $this->_db->quote($name) . ' AND
						field_value = ' . $this->_db->quote($value);
				}
			}

			$this->_db->query(substr($sql, 0, -1));
			$this->_processedLog['inserted']['xf_content_type_field'] = $logs;

			$this->_rebuildContentTypesCache();
		}

		protected function _uninstall()
		{
			if ( ! empty($this->_tables))
			{
				$this->_dropTables(array_keys($this->_tables));
			}

			if ( ! empty($this->_contentTypes))
			{
				$this->_removeContentTypes($this->_contentTypes);
			}
		}

		protected function _rollback()
		{
			// TODO
		}

		protected function _dropTables(array $tables)
		{
			foreach ($tables AS $table)
			{
				if (($pos = strpos($table, ':')) !== false)
				{
					$table = substr($table, 0, $pos);
				}

				$this->_db->query("DROP TABLE IF EXISTS $table");
			}
		}

		protected function _removeContentTypes(array $contentTypes)
		{
			foreach ($contentTypes AS $contentType => $fields)
			{
				$this->_db->delete('xf_content_type', '
					content_type = ' . $this->_db->quote($contentType) . ' AND
					addon_id = ' . $this->_db->quote($this->_existingAddon['addon_id']) . '
				');

				foreach ($fields AS $name => $value)
				{
					$this->_db->delete('xf_content_type_field', '
						content_type = ' . $this->_db->quote($contentType) . ' AND
						field_name = ' . $this->_db->quote($name) . ' AND
						field_value = ' . $this->_db->quote($value) . '
					');
				}
			}

			$this->_rebuildContentTypesCache();
		}

		protected function _rebuildContentTypesCache()
		{
			$this->getModelFromCache('XenForo_Model_ContentType')->rebuildContentTypeCache();
		}

		protected function _upgrade()
		{
			$start = $this->_existingAddon['version_id'] + 1;

			XenForo_Db::beginTransaction($this->_db);

			$this->_installFromData();

			try
			{
				for ($v = $start; $v <= $this->_addonData['version_id']; ++$v)
				{
					if (!$this->_callUpgradeMethod($v))
					{
						break;
					}
				}
			}
			catch (Exception $e)
			{
				XenForo_Db::rollback($this->_db);
				throw $e;
			}

			XenForo_Db::commit($this->_db);
		}

		public function run($uninstall = false)
		{
			if ($uninstall)
			{
				$this->_uninstall();
				return;
			}

			if ( ! $this->_existingAddon)
			{
				$this->_install();
				return;
			}

			$this->_upgrade();
		}

		protected function _callUpgradeMethod($version)
		{
			if (method_exists($this, '_upgradeVersion' . $version))
			{
				return $this->{'_upgradeVersion' . $version}();
			}
		}
	}
}

eval('abstract class Merc_' . $folder . '_Common_Installer extends Merc_Common_Installer_Version03 {}');
