<?php

/*
 *  Merc Common Library
 *  Listener.php 0.3
 *  (this library added like this so I don't have to worry about backwards compatability)
 *
 *  This class is to make using listeners less tedious.
 */

$folder = basename(dirname(dirname(__FILE__)));
require_once XenForo_Application::getInstance()->getRootDir() . '/library/Merc/' . $folder . '/Common/Base.php';
// Note: eval at bottom of file

if ( ! class_exists('Merc_Common_Listener_Version03'))
{
	abstract class Merc_Common_Listener_Version03 extends Merc_Common_Base_Version03
	{
		public function callTemplateMethod($name, &$content)
		{
			$methodName = '_'.lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', $name))));

			if (method_exists($this, $methodName))
			{
				return $this->$methodName($content);
			}
		}

		/**
		 * Used as a shortcut to have all classes in a directory extend.
		 * For example if a class XenPlus_Extend_Model_User existed and this was called with getExtension($className, 'XenPlus_Extend_')
		 * then it would return true when XenForo_Model_User is called, then you could add it to $extend in your listener.
		 *
		 * @param  string $className
		 * @param  string $prefix
		 * @param  string $replace
		 * @return mixed false if no class, string of new class if it exists
		 */
		public function getExtension($className, $prefix = '', $replace = 'XenForo_')
		{
			$className = $prefix . $className;
			if ($replace)
			{
				$className = str_replace($replace, '', $className);
			}

			$filename = XenForo_Autoloader::getInstance()->autoloaderClassToFile($className);
			return $filename && file_exists($filename) ? $className : false;
		}

		public function extendClasses($class, array &$extend)
		{
			$classes = $this->getExtendedClasses();
			if (isset($classes[$class]) && !in_array($classes[$class], $extend))
			{
				$extend[] = $classes[$class];
			}
		}

		public function getExtendedClasses()
		{
			return array();
		}

		public function insertContent(&$contents, $newContent, $pos, $after = false)
		{
			if ( ! is_int($pos))
			{
				$newPos = strpos($contents, $pos);
				if ($after)
					$newPos += strlen($pos);
				$pos = $newPos;
			}

			$contents = substr($contents, 0, $pos) . $newContent . substr($contents, $pos);
		}
	}
}

eval('abstract class Merc_' . $folder . '_Common_Listener extends Merc_Common_Listener_Version03 {}');
