<?php

class Merc_DonationManager_ControllerAdmin_Donation extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('manageDonations');
	}

	public function actionIndex()
	{
		$donateModel = $this->_getDonationModel();

		$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$perPage = 20;

		$conditions = array();

		$fetchOptions = array(
			'page' => $page,
			'perPage' => $perPage,
			'join' => Merc_DonationManager_Model_Donation::FETCH_GOAL
		);

		$filter = $this->_input->filterSingle('_filter', XenForo_Input::ARRAY_SIMPLE);
		if ($filter && isset($filter['value']))
		{
			$conditions['username'] = array($filter['value'], empty($filter['prefix']) ? 'lr' : 'r');
			$filterView = true;
		}
		else
		{
			$filterView = false;
		}

		$totalDonations = $donateModel->countDonations($conditions);

		$viewParams = array(
			'donations' => $donateModel->getDonations($conditions, $fetchOptions),

			'currency' => strtoupper(XenForo_Application::get('options')->donationCurrency),

			'totalDonations' => $totalDonations,
			'perPage' => $perPage,
			'page' => $page,

			'filterView' => $filterView,
			'filterMore' => ($filterView && $totalDonations > $perPage)
		);

		return $this->responseView('Merc_DonationManager_ViewAdmin_Donation_List', 'merc_donation_list', $viewParams);
	}

	public function actionAdd()
	{
		$viewParams = $this->_getAddEditDateData() + array(
			'donation' => array(
				'user_donation_id' => 0,
				'user_id' => 0,
				'username' => '',
				'amount' => 0,
				'note' => '',
				'anonymous' => 0,
				'donation_date' => 0,
			)
		);

		return $this->_getAddEditResponse('Merc_DonationManager_ViewAdmin_Donation_Add', $viewParams);
	}

	public function actionEdit()
	{
		$donateId = $this->_input->filterSingle('donation_id', XenForo_Input::UINT);

		if (!$donateId || !$donation = $this->_getDonationModel()->getDonationById($donateId))
			return $this->responseNoPermission();

		list($donation['date'], $donation['hour'], $donation['minute']) = explode(',', date('Y-m-d,H,i', $donation['donation_date']));

		$viewParams = $this->_getAddEditDateData() + array(
			'donation' => $donation
		);

		return $this->_getAddEditResponse('Merc_DonationManager_ViewAdmin_Donation_Edit', $viewParams);
	}

	protected function _getAddEditResponse($viewClass, $viewParams)
	{
		$viewParams += $this->getHelper('Merc_DonationManager_ControllerHelper_Date')->getDateDataParams();
		$viewParams = array_merge(array(
			'goals' => $this->_getGoalModel()->getGoals(),
		), $viewParams);

		return $this->responseView($viewClass, 'merc_donation_edit', $viewParams);
	}

	protected function _getAddEditDateData()
	{
		// TODO: call this directly instead of in here, just doing a quick hack for now
		return $this->getHelper('Merc_DonationManager_ControllerHelper_Date')->getDateDataParams();

		$hours = array();
		for ($i = 0; $i < 24; $i++)
		{
			$hh = str_pad($i, 2, '0', STR_PAD_LEFT);
			$hours[$hh] = $hh;
		}

		$minutes = array();
		for ($i = 0; $i < 60; $i += 1)
		{
			$mm = str_pad($i, 2, '0', STR_PAD_LEFT);
			$minutes[$mm] = $mm;
		}

		return array('hours' => $hours, 'minutes' => $minutes);
	}

	public function actionSave()
	{
		$this->_assertPostOnly();

		$donateId = $this->_input->filterSingle('donation_id', XenForo_Input::UINT);

		$data = $this->_input->filter(array(
			'username' => XenForo_Input::STRING,
			'user_id' => XenForo_Input::UINT,
			'amount' => XenForo_Input::FLOAT,
			'anonymous' => XenForo_Input::BINARY,
			'note' => XenForo_Input::STRING,
			'goal_id' => XenForo_Input::UINT,
		));

		$dateInput = $this->_input->filter(array(
			'date' => XenForo_Input::STRING,
			'hour' => XenForo_Input::UINT,
			'minute' => XenForo_Input::UINT
		));

		if (!empty($dateInput['date']))
		{
			$datetime = new DateTime("$dateInput[date] $dateInput[hour]:$dateInput[minute]");
			$data['donation_date'] = $datetime->format('U');
		}

		if (empty($data['user_id']))
		{
			$userModel = $this->getModelFromCache('XenForo_Model_User');
			$data['user_id'] = $userModel->getUserIdFromUser($userModel->getUserByName($data['username']));
		}

		$dw = XenForo_DataWriter::create('Merc_DonationManager_DataWriter_Donation');
		if ($donateId)
			$dw->setExistingData($donateId);

		$dw->bulkSet($data);
		$dw->set('transaction_id', 0);

		$dw->save();

		return $this->responseRedirect(
			$donateId ? XenForo_ControllerResponse_Redirect::RESOURCE_UPDATED : XenForo_ControllerResponse_Redirect::RESOURCE_CREATED,
			XenForo_Link::buildAdminLink('donations')
		);
	}

	public function actionDelete()
	{
		$donateId = $this->_input->filterSingle('donation_id', XenForo_Input::UINT);
		if (!$donation = $this->_getDonationModel()->getDonationById($donateId))
			return $this->responseNoPermission();

		if ($this->isConfirmedPost())
		{
			$dw = XenForo_DataWriter::create('Merc_DonationManager_DataWriter_Donation');
			$dw->setExistingData($donateId);
			$dw->delete();

			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildAdminLink('donations'));
		}

		if ($donation['anonymous'])
		{
			$donation['user_id'] = 0;
			$donation['username'] = new XenForo_Phrase('merc_anonymous');
		}

		$viewParams = array(
			'donation' => $donation,
		);

		return $this->responseView('Merc_DonationManager_ViewAdmin_Donation_Delete', 'merc_donation_delete', $viewParams);
	}

	protected function _getDonationModel()
	{
		return $this->getModelFromCache('Merc_DonationManager_Model_Donation');
	}

	protected function _getGoalModel()
	{
		return $this->getModelFromCache('Merc_DonationManager_Model_Goal');
	}
}