<?php

class Merc_DonationManager_ControllerAdmin_DonationLog extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('viewLogs');
	}

	public function actionIndex()
	{
		if ($this->_input->filterSingle('donation_log_id', XenForo_Input::UINT))
		{
			return $this->actionDetail();
		};

		$donationLogModel = $this->_getDonationLogModel();
		$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$perPage = 20;		

		$conditions = array();
		
		$fetchOptions = array('page' => $page, 'perPage' => $perPage);

		$donationLogs = $donationLogModel->getDonationLogs($conditions,$fetchOptions);
		$donationLogsCount = $donationLogModel->countDonationLogs($conditions);
		$viewParams = array_merge(array(
			'logs' => $donationLogs,
			'total' => $donationLogsCount,
			'pageParams' => array()
			),$fetchOptions);

		return $this->responseView('Merc_DonationManager_ViewAdmin_DonationLog_List', 'merc_donation_log_list', $viewParams);
	}

	public function actionDetail()
	{
		$id = $this->_input->filterSingle('donation_log_id', XenForo_Input::UINT);
		
		$donationLogModel = $this->_getDonationLogModel();

		$log = $donationLogModel->getDonationLogById($id);

		if (!$log)
			{
				return $this->responseError(new XenForo_Phrase('requested_log_entry_not_found'), 404);
			}

			$log['transactionDetails'] = unserialize($log['transaction_details']);
		
		$viewParams = array(
			'log' => $log
		);

		return $this->responseView('Merc_DonationManager_ViewAdmin_DonationLog_Detail', 'merc_donation_log_detail', $viewParams);

	}

	protected function _getDonationLogModel()
	{
		return $this->getModelFromCache('Merc_DonationManager_Model_DonationLog');
	}
}