<?php

class Merc_DonationManager_ControllerAdmin_Goal extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('manageDonations');
	}

	public function actionIndex()
	{
		$viewParams = array(
			'goals' => $this->_getGoalModel()->getGoals()
		);

		return $this->responseView('Merc_DonationManager_ViewAdmin_Goal_List', 'merc_goal_list', $viewParams);
	}

	public function actionAdd()
	{
		$viewParams = array(
			'goal' => array(
				'goal_id' => 0,

				'display_order' => 0
			),
		) + $this->getHelper('Merc_DonationManager_ControllerHelper_Date')->getDateDataParams();;

		return $this->responseView('Merc_DonationManager_ViewAdmin_Goal_Edit', 'merc_goal_edit', $viewParams);
	}

	public function actionEdit()
	{
		$goalId = $this->_input->filterSingle('goal_id', XenForo_Input::UINT);

		if (!$goalId || !$goal = $this->_getGoalModel()->getGoalById($goalId))
		{
			return $this->responseNoPermission();
		}

		list($goal['start_date'], $goal['start_hour'], $goal['start_minute']) = explode(',', date('Y-m-d,H,i', $goal['start_date']));
		if ($goal['end_date'])
		{
			list($goal['end_date'], $goal['end_hour'], $goal['end_minute']) = explode(',', date('Y-m-d,H,i', $goal['end_date']));
		}
		else
		{
			$goal['end_date'] = '';
		}

		$viewParams = array(
			'goal' => $goal,
		) + $this->getHelper('Merc_DonationManager_ControllerHelper_Date')->getDateDataParams();;

		return $this->responseView('Merc_DonationManager_ViewAdmin_Goal_Edit', 'merc_goal_edit', $viewParams);
	}

	public function actionSave()
	{
		$this->_assertPostOnly();

		$goalId = $this->_input->filterSingle('goal_id', XenForo_Input::UINT);
		$input = $this->_input->filter(array(
			'title' => XenForo_Input::STRING,
			'description' => XenForo_Input::STRING,
			'goal' => XenForo_Input::FLOAT,
			'goal_reached' => XenForo_Input::STRING,
			'recurring' => XenForo_Input::UINT,
			'feature' => XenForo_Input::UINT,
			'display_order' => XenForo_Input::UINT,
			'recurring' => XenForo_Input::UINT,
		));

		$dateInput = $this->_input->filter(array(
			'start_date' => XenForo_Input::STRING,
			'start_hour' => XenForo_Input::UINT,
			'start_minute' => XenForo_Input::UINT,
			'end_date' => XenForo_Input::STRING,
			'end_hour' => XenForo_Input::UINT,
			'end_minute' => XenForo_Input::UINT
		));

		if (!empty($dateInput['start_date']))
		{
			$datetime = new DateTime("$dateInput[start_date] $dateInput[start_hour]:$dateInput[start_minute]");
			$input['start_date'] = $datetime->format('U');
		}

		if (!empty($dateInput['end_date']))
		{
			$datetime = new DateTime("$dateInput[end_date] $dateInput[end_hour]:$dateInput[end_minute]");
			$input['end_date'] = $datetime->format('U');
		}

		$dw = XenForo_DataWriter::create('Merc_DonationManager_DataWriter_Goal');
		if ($goalId)
		{
			$dw->setExistingData($goalId);
		}

		$dw->bulkSet($input);
		$dw->save();

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildAdminLink('goals'));
	}

	public function actionArchive()
	{
		$goalId = $this->_input->filterSingle('goal_id', XenForo_Input::UINT);
		if (!$goalId || !$goal = $this->_getGoalModel()->getGoalById($goalId))
		{
			return $this->responseNoPermission();
		}

		$viewParams = array(
			'goal' => $goal,
		);

		return $this->responseView('Merc_DonationManager_ViewAdmin_Goal_Archive', 'merc_goal_archive', $viewParams);
	}

	public function actionDelete()
	{
		$goalId = $this->_input->filterSingle('goal_id', XenForo_Input::UINT);
		if (!$goalId || !$goal = $this->_getGoalModel()->getGoalById($goalId))
		{
			return $this->responseNoPermission();
		}

		if ($this->isConfirmedPost())
		{
			// TODO: check weather to log or not.. maybe? dunno...

			$dw = XenForo_DataWriter::create('Merc_DonationManager_DataWriter_Goal');
			$dw->setExistingData($goalId);
			$dw->delete();

			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildAdminLink('goals'));
		}

		$viewParams = array(
			'goal' => $goal,
		);

		return $this->responseView('Merc_DonationManager_ViewAdmin_Goal_Delete', 'merc_goal_delete', $viewParams);
	}

	/*public function actionLog()
	{
		$this->assertAdminPermission('donationManager');

		$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$perPage = 24;

		$goals = $this->_getDonationModel()->getGoalLogs(array(
			'page' => $page,
			'perPage' => $perPage
		));

		$groupedGoals = array();
		foreach ($goals as $goalId => $goal)
		{
			$year = date('Y', $goal['goal_date']);
			$goal['month'] = new XenForo_Phrase('merc_' . strtolower(date('F', $goal['goal_date'])));
			$groupedGoals[$year][$goalId] = $goal;
		}

		$viewParams = array(
			'goals' => $groupedGoals,

			'page' => $page,
			'perPage' => $perPage,
			'total' => $this->_getDonationModel()->countGoals(),
			'totalShowing' => count($goals)
		);

		return $this->responseView('Merc_DonationManager_ViewAdmin_Goal_Log', 'merc_donation_goal_log', $viewParams);
	}*/

	protected function _getGoalModel()
	{
		return $this->getModelFromCache('Merc_DonationManager_Model_Goal');
	}
}