<?php

class Merc_DonationManager_ControllerPublic_Donate extends XenForo_ControllerPublic_Abstract
{
	protected function _preDispatch($action)
	{
		if (!XenForo_Visitor::getInstance()->hasPermission('donation', 'viewIndex'))
		{
			throw $this->responseException($this->responseNoPermission());
		}
	}

	public function actionIndex()
	{
		$goals = $this->_getGoalModel()->getGoals(
			array(
				'archived' => 0,
				'hideFuture' => 1
			),
			array(
				'join' => Merc_DonationManager_Model_Goal::FETCH_LOG_COUNT
			)
		);
		if (count($goals) == 1)
		{
			$this->_request->setParam('goal_id', key($goals));
			return $this->responseReroute('Merc_DonationManager_ControllerPublic_Goal', 'index');
		}

		if (!$goals)
		{
			return $this->responseReroute(__CLASS__, 'donate');
		}

		// TODO: this is copied somewhere else, use a helper or something
		$options = XenForo_Application::getOptions();
		$amounts = $options->donationAmounts;
		$totalAmount = 0;
		if (!empty($amounts))
		{
			$amounts = explode(',', $amounts);
			foreach ($amounts as $k => $amount)
			{
				$amount = (int) $amount;
				if (empty($amount) || $amount < (int) $options->minimumDonationAmount)
				{
					unset($amounts[$k]);
				}
				else
				{
					$amounts[$k] = $amount;
					$totalAmount += $amount;
				}
			}
		}

		$averageAmount = round($totalAmount / count($amounts)) - 0.05;

		$sidebarHelper = $this->getHelper('Merc_DonationManager_ControllerHelper_Sidebar');
		$viewParams = array(
			'goals' => $this->_getGoalModel()->prepareGoals($goals),

			'topDonors' => $sidebarHelper->getTopDonors(),
			'topDonations' => $sidebarHelper->getTopDonations(),

			'amounts' => $amounts,
			'allowOpenAmount' => $options->allowOpenDonationAmount || empty($amounts),
			'averageAmount' => $averageAmount,

			'canDonate' => XenForo_Visitor::getInstance()->hasPermission('donation', 'donate'),

			'thanks' => $this->_input->filterSingle('thanks', XenForo_Input::UINT),
		);

		$containerParams = array(
			'showDonationsOffNotice' => !XenForo_Application::getOptions()->acceptingDonations
		);

		return $this->responseView('Merc_DonationManager_ViewPublic_Donate_GoalList', 'merc_goal_list', $viewParams, $containerParams);
	}

	public function actionDonate()
	{
		$donations = array();
		if (XenForo_Visitor::getInstance()->hasPermission('donation', 'viewDonations'))
		{
			$donations = $this->_getDonationModel()->getDonations(array(), array('limit' => 7));
		}

		// TODO: this is copied somewhere else, use a helper or something
		$options = XenForo_Application::getOptions();
		$amounts = $options->donationAmounts;
		$totalAmount = 0;
		if (!empty($amounts))
		{
			$amounts = explode(',', $amounts);
			foreach ($amounts as $k => $amount)
			{
				$amount = (int) $amount;
				if (empty($amount) || $amount < (int) $options->minimumDonationAmount)
				{
					unset($amounts[$k]);
				}
				else
				{
					$amounts[$k] = $amount;
					$totalAmount += $amount;
				}
			}
		}

		$averageAmount = round($totalAmount / count($amounts)) - 0.05;

		$sidebarHelper = $this->getHelper('Merc_DonationManager_ControllerHelper_Sidebar');
		$viewParams = array(
			'goals' => $this->_getGoalModel()->getGoals(array('archived' => 0)),

			'topDonors' => $sidebarHelper->getTopDonors(),
			'topDonations' => $sidebarHelper->getTopDonations(),

			'recentDonations' => $donations,

			'amounts' => $amounts,
			'allowOpenAmount' => $options->allowOpenDonationAmount || empty($amounts),
			'averageAmount' => $averageAmount,

			'donating' => true,
			'canDonate' => XenForo_Visitor::getInstance()->hasPermission('donation', 'donate'),

			'thanks' => $this->_input->filterSingle('thanks', XenForo_Input::UINT),
		);

		if ($viewParams['donating'] && !$options->acceptingDonations)
		{
			$error = $options->notAcceptingDonationsMessage;
			if (empty($error))
			{
				$error = new XenForo_Phrase('merc_donations_arent_currently_being_accepted');
			}

			return $this->responseError(nl2br($error));
		}

		$containerParams = array(
			'showDonationsOffNotice' => !XenForo_Application::getOptions()->acceptingDonations
		);

		return $this->responseView('Merc_DonationManager_ViewPublic_Donate_Standalone', 'merc_donate_standalone', $viewParams, $containerParams);
	}

	public function actionConfirm()
	{
		$this->_assertPostOnly();

		$visitor = XenForo_Visitor::getInstance();
		$options = XenForo_Application::get('options');

		if (!$visitor->hasPermission('donation', 'donate'))
		{
			return $this->responseNoPermission();
		}

		if (!$options->acceptingDonations)
		{
			$error = $options->notAcceptingDonationsMessage;
			if (empty($error))
			{
				$error = new XenForo_Phrase('merc_donations_arent_currently_being_accepted');
			}

			return $this->responseError(nl2br($error));
		}

		$data = $this->_input->filter(array(
			'goal_id' => XenForo_Input::UINT,
			'amount' => XenForo_Input::UINT,
			'other_amount' => XenForo_Input::UINT,
			'note' => XenForo_Input::STRING,
			'anonymous' => XenForo_Input::UINT,
		));

		if (!empty($data['amount']))
		{
			$amount = $data['amount'];
		}
		else if (!empty($data['other_amount']))
		{
			$amount = $data['other_amount'];
		}

		if (!isset($amount) || $amount < $options->minimumDonationAmount)
		{
			return $this->responseError(new XenForo_Phrase('merc_donation_amount_does_not_meet_the_set_minimum'));
		}

		$goal = array();
		if (!empty($data['goal_id']) AND !$goal = $this->_getGoalModel()->getGoalById($data['goal_id']))
		{
			return $this->responseError(new XenForo_Phrase('specified_goal_doesnt_exist'));
		}

		$token = $this->_getTransactionModel()->start($visitor->user_id, $goal ? $goal['goal_id'] : 0, $amount, $data['note'], $data['anonymous']);

		$viewParams = array(
			'token' => $token,

			'goal' => $goal,
			'amount' => $amount,
			'note' => substr($data['note'], 0, 150),
			'anonymous' => $data['anonymous'],
		);

		return $this->responseView('Merc_DonationManager_ViewPublic_Donate_Confirm', 'merc_donate_confirm', $viewParams);
	}

	public function actionPayPal()
	{
		$visitor 		= XenForo_Visitor::getInstance();
		$options 		= XenForo_Application::get('options');
		$config         = XenForo_Application::get('config');

		if (!$options->acceptingDonations)
		{
			$error = $options->notAcceptingDonationsMessage;
			if (empty($error))
			{
				$error = new XenForo_Phrase('merc_donations_arent_currently_being_accepted');
			}

			return $this->responseError(nl2br($error));
		}

		$token = $this->_input->filterSingle('token', XenForo_Input::STRING);
		if (!$token OR !($transaction = $this->_getTransactionModel()->getTransaction($token)))
		{
			return $this->responseError('Token was invalida, please try again.');
		}

		$paths = XenForo_Application::getRequestPaths(new Zend_Controller_Request_Http);

		$notifyUri = 'donation_manager_callback.php';
		if ( ! empty($config->donation_manager->paypal_callback))
		{
			$notifyUri = $config->donation_manager->paypal_callback;
		}

		$params = array(
			'amount' => $transaction['amount'],
			'cmd' => $options->donationAsPayment ? '_xclick' : '_donations',
			'business' => $options->payPalPrimaryAccount,
			'currency_code' => $options->donationCurrency,
			'item_name' => (string) new XenForo_Phrase('donation_to_forumname_username', array('forumname' => $options->boardTitle, 'username' => $visitor->username)),
			'quantity' => 1,
			'no_shipping' => 1,
			'no_note' => 1,
			'charset' => 'utf-8',
			'lc' => 'EN',
			'custom' => "$token,$visitor->csrf_token_page",
			'return' => $paths['fullBasePath'] . XenForo_Link::buildPublicLink('donate/thank-you'),
			'cancel_return' => $paths['fullBasePath'] . XenForo_Link::buildPublicLink('donate'),
			'notify_url' => $paths['fullBasePath'] . $notifyUri
		);

		header('Location: https://www.' . ($options->payPalSandbox ? 'sandbox.' : '') . 'paypal.com/cgi-bin/websrc?' . http_build_query($params, '', '&'));
		exit();
	}

	public function actionThankYou()
	{
		$this->_request->setParam('thanks', 1);
		return $this->responseReroute(__CLASS__, 'index');
	}

	protected function _checkCsrf($action)
	{
		if (strtolower($action) == 'thankyou' OR 
			(strtolower($action) == 'donate' && $this->_input->filterSingle('thanks', XenForo_Input::UINT)) OR 
			(strtolower($action) == 'index' && $this->_input->filterSingle('thanks', XenForo_Input::UINT)))
		{
			// may be coming from external payment gateway
			return;
		}

		parent::_checkCsrf($action);
	}

	protected function _getDonationModel()
	{
		return $this->getModelFromCache('Merc_DonationManager_Model_Donation');
	}

	protected function _getGoalModel()
	{
		return $this->getModelFromCache('Merc_DonationManager_Model_Goal');
	}

	protected function _getTransactionModel()
	{
		return $this->getModelFromCache('Merc_DonationManager_Model_Transaction');
	}
}