<?php

class Merc_DonationManager_DataWriter_Donation extends XenForo_DataWriter
{
	protected function _getFields()
	{
		return array(
			'merc_donation' => array(
				'donation_id' => array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'transaction_id' => array('type' => self::TYPE_UINT, 'required' => true),
				'user_id' => array('type' => self::TYPE_UINT, 'default' => 0),
				'goal_id' => array('type' => self::TYPE_UINT, 'default' => 0, 'verification' => array('$this', '_verifyGoalId')),
				'username' => array('type' => self::TYPE_STRING, 'required' => true),
				'amount' => array('type' => self::TYPE_FLOAT, 'required' => true, 'verification' => array('$this', '_verifyAmount')),
				'note' => array('type' => self::TYPE_STRING, 'maxLength' => 150, 'default' => ''),
				'donation_date' => array('type' => self::TYPE_UINT, 'default' => XenForo_Application::$time),
				'anonymous' => array('type' => self::TYPE_BOOLEAN, 'default' => 0)
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('merc_donation' => $this->_getDonationModel()->getDonationById($id));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'donation_id = ' . $this->_db->quote($this->getExisting('donation_id'));
	}

	protected function _verifyAmount(&$amount)
	{
		if ($amount <= 0)
		{
			$this->error(new XenForo_Phrase('merc_please_enter_a_donation_amount_greater_than_zero'), 'amount');
			return false;
		}
		else
		{
			return true;
		}
	}

	protected function _verifyGoalId(&$goalId)
	{
		if (empty($goalId))
		{
			return true;
		}

		$goals = $this->_getGoalModel()->getGoals();
		if (!isset($goals[$goalId]))
		{
			$goalId = 0;
		}

		return true;
	}

	protected function _preSave()
	{
		/*if ($this->get('anonymous'))
		{
			$this->set('username', new XenForo_Phrase('merc_anonymous'));
		}*/
	}

	protected function _postSave()
	{
		$this->updateGoalAndUserAmountTotals($this->get('amount'));

		Merc_DonationManager_Common_Helper::promoteUsers($this->get('user_id'));
	}

	protected function _postDelete()
	{
		$this->updateGoalAndUserAmountTotals(-$this->get('amount'));
	}

	protected function updateGoalAndUserAmountTotals($amount)
	{
		$oldData = $this->getMergedExistingData();
		$newData = $this->getMergedData();

		if ($amount < 0)
		{
			// Deleting, just do remove
			$this->_getGoalModel()->removeDonationFromGoalIfChanged($oldData, array('goal_id' => 0, 'donation_date' => 0));
		}
		else
		{
			$addToGoal = $this->isInsert();
			if ($this->isUpdate() AND ($this->isChanged('goal_id') OR $this->isChanged('donation_date')))
			{
				$addToGoal = $this->_getGoalModel()->removeDonationFromGoalIfChanged($oldData, $newData);
			}

			if ($addToGoal || $this->isChanged('amount'))
			{
				if (!$addToGoal)
				{
					$newData['amount'] -= $oldData['amount'];
				}

				$this->_getGoalModel()->addDonationToGoal($newData);
			}
		}

		if ($this->isUpdate())
		{
			$amount -= $this->getExisting('amount');
		}

		$whereClause = 'user_id = ' . $this->get('user_id') . ' AND anonymous = ' . $this->get('anonymous');

		if (!$this->_db->fetchRow('SELECT * FROM merc_donor WHERE ' . $whereClause))
		{
			if ($amount <= 0)
			{
				return;
			}

			$this->_db->insert('merc_donor', array(
				'user_id' => $this->get('user_id'),
				'anonymous' => $this->get('anonymous'),
				'amount' => $this->get('amount')
			));
		}
		else
		{
			$this->_db->query('
				UPDATE merc_donor
				SET amount = GREATEST(0, amount + ?)
				WHERE ' . $whereClause
			, $amount);

			$this->_db->delete('merc_donor', 'amount <= 0');
		}

		$lastDonationDate = $this->_db->fetchOne('
			SELECT donation_date
			FROM merc_donation
			WHERE user_id = ? AND anonymous = ?
			ORDER BY donation_date DESC
			LIMIT 1
		', array($this->get('user_id'), $this->get('anonymous')));

		$this->_db->query('
			UPDATE merc_donor
			SET last_donation_date = ?
			WHERE ' . $whereClause
		, (int) $lastDonationDate);
	}

	protected function _getDonationModel()
	{
		return $this->getModelFromCache('Merc_DonationManager_Model_Donation');
	}

	protected function _getGoalModel()
	{
		return $this->getModelFromCache('Merc_DonationManager_Model_Goal');
	}
}