<?php

class Merc_DonationManager_Helper_Color
{
	public static function helperProgressBarRGB($percent)
	{
		$percent = max(0, min(100, $percent));

		$rgb = self::_hsvToRgb($percent, 100, 72);
		return "$rgb[0], $rgb[1], $rgb[2]";
	}

	protected static function _hsvToRgb($h, $s, $v)
	{
		$h /= 360;
		$s /= 100;
		$v /= 100;

		if ($s == 0)
		{
			$r = $v * 255;
			$g = $v * 255;
			$b = $v * 255;
		}
		else
		{
			$_h = $h * 6;
			$_i = floor($_h);
			$_1 = $v * (1 - $s);
			$_2 = $v * (1 - $s * ($_h - $_i));
			$_3 = $v * (1 - $s * (1 - ($_h - $_i)));

			if ($_i == 0)
			{
				$_r = $v;
				$_g = $_3;
				$_b = $_1;
			}
			else if ($_i == 1)
			{
				$_r = $_2;
				$_g = $v;
				$_b = $_1;
			}
			else if ($_i == 2)
			{
				$_r = $_1;
				$_g = $v;
				$_b = $_3;
			}
			else if ($_i == 3)
			{
				$_r = $_1;
				$_g = $_2;
				$_b = $v;
			}
			else if ($_i == 4)
			{
				$_r = $_3;
				$_g = $_1;
				$_b = $v;
			}
			else
			{
				$_r = $v;
				$_g = $_1;
				$_b = $_2;
			}

			$r = $_r * 255;
			$g = $_g * 255;
			$b = $_b * 255;
		}

		return array(round($r), round($g), round($b));
	}

	protected static function _rgbToHsv($r, $g, $b)
	{
		$r /= 255;
		$g /= 255;
		$b /= 255;

		$min = min($r, $g, $b);
		$max = max($r, $g, $b);

		$v = $max;
		$delta = $max - $min;

		if ($delta == 0)
		{
			return array(0, 0, $v * 100);
		}

		if ($max != 0)
		{
			$s = $delta / $max;
		}
		else
		{
			return array(-1, 0, $v);
		}

		if ($r == $max)
		{
			$h = ($g - $b) / $delta;
		}
		else if ($g == $max)
		{
			$h = 2 + ($b - $r) / $delta;
		}
		else
		{
			$h = 4 + ($r - $g) / $delta;
		}

		$h *= 60;
		if ($h < 0)
		{
			$h += 360;
		}

		return array($h, $s * 100, $v * 100);
	}
}