<?php

class Merc_DonationManager_Helper_Currency
{
	protected static $_currencies = array(
		'AUD', 'CAD', 'EUR', 'GBP', 'JPY', 'USD', 'NZD', 'CHF', 'HKD', 'SGD', 'SEK', 'DKK', 'PLN', 'NOK',
		'HUF', 'CZK', 'ILS', 'MXN', 'BRL', 'MYR', 'PHP', 'TWD', 'THB', 'TRY');

	public static function getAbbreviations()
	{
		return self::$_currencies;
	}

	public static function getCurrencies()
	{
		$ret = array();
		foreach (self::$_currencies as $cur)
		{
			$ret[$cur] = new XenForo_Phrase('merc_currency_' . $cur);
		}

		return $ret;
	}

	public static function getAmountForTemplate($amount, $currency, $html = false)
	{
		if (!in_array($currency, self::$_currencies))
		{
			$currency = 'USD';
		}

		return new XenForo_Phrase('merc_amount_'.($html ? '' : 'txt_').$currency, array('amount' => $amount));
	}

	public static function helperAmountText($amount, $html = false, $currency = null)
	{
		$html = ($html === true or $html === 1 or $html === 'true' or $html === '1' or $html === 'yes');

		if ($currency === null)
		{
			$currency = XenForo_Application::get('options')->donationCurrency;
		}

		return self::getAmountForTemplate(XenForo_Locale::numberFormat($amount, 2), $currency, $html);
	}
}