<?php

class Merc_DonationManager_Helper_Goal
{
	public static function helperGoalTimeLeft($time)
	{
		if (empty($time))
		{
			return;
		}

		$days = ($time - XenForo_Application::$time) / 86400;

		if ($days <= 1)
		{
			$phrase = 'merc_ending_today';
			return new XenForo_Phrase($phrase);
		}
		else if ($days <= 90)
		{
			$days = round($days);
			$phrase = $days == 1 ? 'x_day_left' : 'x_days_left';
			return new XenForo_Phrase($phrase, array('days' => $days));
		}
		else if ($days <= 730)
		{
			$months = round($days / 30);
			$phrase = $months == 1 ? 'x_month_left' : 'x_months_left';
			return new XenForo_Phrase($phrase, array('months' => $months));
		}
		else
		{
			$years = round($days / 365);
			$phrase = $years == 1 ? 'x_year_left' : 'x_years_left';
			return new XenForo_Phrase($phrase, array('years' => $years));
		}
	}
}