<?php

class Merc_DonationManager_Model_Donation extends XenForo_Model
{
	const FETCH_USER = 0x01;
	const FETCH_GOAL = 0x02;

	public function getDonationById($id, $hideAnonymous = false)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM merc_donation
			WHERE donation_id = ?
		', $id);
	}

	public function getDonations(array $conditions = array(), array $fetchOptions = array(), $showAnonymousNick = false)
	{
		$whereClause = $this->prepareDonationConditions($conditions, $fetchOptions);
		$orderClause = $this->prepareDonationOrderOptions($fetchOptions, 'donation.donation_date DESC');
		$joinOptions = $this->prepareDonationFetchOptions($fetchOptions);
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);

		$donations = $this->fetchAllKeyed($this->limitQueryResults(
			'
				SELECT donation.*, user.*,
					IF(user.username IS NULL, donation.username, user.username) AS username,
					IF(user.user_id IS NULL, 0, user.user_id) AS user_id
					' . $joinOptions['selectFields'] . '
				FROM merc_donation AS donation
				LEFT JOIN xf_user AS user ON (donation.user_id = user.user_id)
				' . $joinOptions['joinTables'] . '
				WHERE ' . $whereClause . '
				' . $orderClause . '
			', $limitOptions['limit'], $limitOptions['offset']
		), 'donation_id');

		return $showAnonymousNick ? $donations : $this->getModelFromCache('Merc_DonationManager_Model_Donor')->hideAnymousUsernames($donations);
	}

	public function countDonations(array $conditions = array())
	{
		$fetchOptions = array();
		$whereClause = $this->prepareDonationConditions($conditions, $fetchOptions);

		return $this->_getDb()->fetchOne('
			SELECT COUNT(*)
			FROM merc_donation AS donation
				LEFT JOIN xf_user AS user ON (donation.user_id = user.user_id)
			WHERE ' . $whereClause
		);
	}

	public function prepareDonationConditions(array $conditions, array &$fetchOptions)
	{
		$db = $this->_getDb();
		$sqlConditions = array();

		if (!empty($conditions['username']))
		{
			if (!is_array($conditions['username']))
			{
				$conditions['username'] = array($conditions['username'], 'lr');
			}

			$sqlConditions[] = '
				IF(donation.anonymous, \'' . new XenForo_Phrase('merc_anonymous') . '\',
					IF(user.username IS NULL, donation.username, user.username)) LIKE ' . XenForo_Db::quoteLike($conditions['username'][0], $conditions['username'][1], $db);
		}

		if (isset($conditions['goal']))
		{
			$sqlConditions[] = 'donation.goal_id = ' . $db->quote($conditions['goal']);
		}

		return $this->getConditionsForClause($sqlConditions);
	}

	public function prepareDonationFetchOptions(array $fetchOptions)
	{
		$selectFields = '';
		$joinTables = '';

		if (!empty($fetchOptions['join']))
		{
			if ($fetchOptions['join'] & self::FETCH_GOAL)
			{
				$selectFields .= ',
					goal.title AS goal_title';
				$joinTables .= '
					LEFT JOIN merc_goal AS goal ON (goal.goal_id = donation.goal_id)';
			}
		}

		return array(
			'selectFields' => $selectFields,
			'joinTables'   => $joinTables
		);
	}

	public function prepareDonationOrderOptions(array &$fetchOptions, $defaultOrderSql = '')
	{
		$choices = array(
			'date' => 'donation.donation_date',
			'amount' => 'donation.amount',
		);

		return $this->getOrderByClause($choices, $fetchOptions, $defaultOrderSql);
	}
}