<?php

class Merc_DonationManager_Model_DonationLog extends XenForo_Model
{
	public function getDonationLogById($donationId)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM merc_donation_log
			WHERE donation_log_id = ?
		', $donationId);
	}
	
	public function getDonationLogs(array $conditions = array(), array $fetchOptions = array())
	{
		$whereClause = $this->prepareDonationLogConditions($conditions, $fetchOptions);
		//$orderClause = $this->prepareDonationLogOrderOptions($fetchOptions, '');
		$joinOptions = $this->prepareDonationLogFetchOptions($fetchOptions);
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
	
		return $this->fetchAllKeyed($this->limitQueryResults(
			'
				SELECT log.*
					' . $joinOptions['selectFields'] . '
				FROM merc_donation_log AS log
				' . $joinOptions['joinTables'] . '
				WHERE ' . $whereClause . '
				ORDER BY log_date DESC
			', $limitOptions['limit'], $limitOptions['offset']
		), 'donation_log_id');
	}
	
	public function prepareDonationLogConditions(array $conditions, array &$fetchOptions)
	{
		$db = $this->_getDb();
		$sqlConditions = array();
	
		if (isset($conditions['donation']))
		{
			$sqlConditions[] = 'log.donation_id = ' . $db->quote($conditions['goal']);
		}
	
		return $this->getConditionsForClause($sqlConditions);
	}
	
	public function prepareDonationLogFetchOptions(array $fetchOptions)
	{
		$selectFields = '';
		$joinTables = '';
	
		return array(
			'selectFields' => $selectFields,
			'joinTables'   => $joinTables
		);
	}
	
	public function countDonationLogs(array $conditions = array())
	{
		$fetchOptions = array();
		$whereClause = $this->prepareDonationLogConditions($conditions, $fetchOptions);
	
		return $this->_getDb()->fetchOne('
			SELECT COUNT(*)
			FROM merc_donation_log AS log
			WHERE ' . $whereClause . '
		');
	}
	
}