<?php

class Merc_DonationManager_Model_Transaction extends XenForo_Model
{
	public function start($userId, $goalId, $amount, $note, $anonymous)
	{
		$token = XenForo_Application::generateRandomString(32);
		$this->_getDb()->insert('merc_donation_transaction', array(
			'token' => $token,
			'user_id' => $userId,
			'goal_id' => $goalId,
			'amount' => $amount,
			'note' => substr($note, 0, 150),
			'anonymous' => $anonymous
		));

		return $token;
	}

	public function getTransaction($token)
	{
		return $this->_getDb()->fetchRow('
			SELECT * FROM
			merc_donation_transaction
			WHERE token = ?
		', $token);
	}

	public function validate($token, $userId, $amount)
	{
		$transaction = $this->getTransaction($token);
		return $transaction AND $userId == $transaction['user_id'] AND $amount = $transaction['amount'];
	}

	public function commit($token)
	{
		$transaction = $this->getTransaction($token);
		if (!$transaction)
		{
			return;
		}

		$user = $this->getModelFromCache('XenForo_Model_User')->getUserById($transaction['user_id']);

		$dw = XenForo_DataWriter::create('Merc_DonationManager_DataWriter_Donation');
		$dw->set('user_id', $transaction['user_id']);
		$dw->set('username', $user ? $user['username'] : (string) new XenForo_Phrase('guest'));
		$dw->set('amount', $transaction['amount']);
		$dw->set('goal_id', $transaction['goal_id']);
		$dw->set('transaction_id', $transaction['transaction_id']);
		$dw->set('anonymous', $transaction['anonymous']);
		$dw->set('note', $transaction['note']);

		$dw->save();

		$this->_getDb()->query('
			UPDATE merc_donation_transaction
			SET transaction_state = \'commited\'
			WHERE token = ?
		', $token);

		return $dw->get('donation_id');
	}

	public function rollback($token)
	{
		$donationId = $this->_getDb()->fetchOne('
			SELECT d.donation_id
			FROM merc_donation_transaction AS t
				LEFT JOIN merc_donation AS d ON (d.transaction_id = t.transaction_id)
			WHERE token = ?
		', $token);

		if ($donationId)
		{
			$dw = XenForo_DataWriter::create('Merc_DonationManager_DataWriter_Donation');
			$dw->setExistingData($donationId);
			$dw->delete();
		}

		$this->_getDb()->query('
			UPDATE merc_donation_transaction
			SET transaction_state = \'reversed\'
			WHERE token = ?
		', $token);

		return $donationId;
	}
/*
	public function getProcessedTransactionLog($transactionId)
	{
		if ($transactionId === '')
		{
			return array();
		}

		return $this->fetchAllKeyed('
			SELECT *
			FROM merc_donation_log
			WHERE transaction_id = ?
				AND transaction_type IN (\'payment\', \'cancel\')
			ORDER BY log_date
		', 'donation_log_id', $transactionId);
	}
 */
	public function logTransaction($donationId, $transactionId, $processor, $transactionType, $message, array $details)
	{
		$this->_getDb()->insert('merc_donation_log', array(
			'donation_id' => $donationId,
			'processor' => $processor,
			'transaction_id' => $transactionId,
			'transaction_type' => $transactionType,
			'message' => substr($message, 0, 255),
			'transaction_details' => serialize($details),
			'log_date' => XenForo_Application::$time
		));

		return $this->_getDb()->lastInsertId();
	}
}